/*
 * Decompiled with CFR 0.152.
 */
package org.jdbi.v3.spring4;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.PostConstruct;
import javax.sql.DataSource;
import org.jdbi.v3.core.Jdbi;
import org.jdbi.v3.core.spi.JdbiPlugin;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.jdbc.datasource.DataSourceUtils;

public class JdbiFactoryBean
implements FactoryBean<Jdbi> {
    private DataSource dataSource;
    private final Map<String, Object> globalDefines = new HashMap<String, Object>();
    private Collection<JdbiPlugin> plugins = Collections.emptyList();

    public JdbiFactoryBean() {
    }

    public JdbiFactoryBean(DataSource dataSource) {
        this.dataSource = dataSource;
    }

    public Jdbi getObject() throws Exception {
        Jdbi jdbi = Jdbi.create(() -> DataSourceUtils.getConnection((DataSource)this.dataSource));
        this.plugins.forEach(arg_0 -> ((Jdbi)jdbi).installPlugin(arg_0));
        this.globalDefines.forEach((arg_0, arg_1) -> ((Jdbi)jdbi).define(arg_0, arg_1));
        return jdbi;
    }

    public Class<Jdbi> getObjectType() {
        return Jdbi.class;
    }

    public boolean isSingleton() {
        return true;
    }

    public JdbiFactoryBean setDataSource(DataSource dataSource) {
        this.dataSource = dataSource;
        return this;
    }

    @Autowired(required=false)
    public JdbiFactoryBean setPlugins(Collection<JdbiPlugin> plugins) {
        this.plugins = plugins;
        return this;
    }

    public void setGlobalDefines(Map<String, Object> defines) {
        this.globalDefines.putAll(defines);
    }

    @PostConstruct
    private void afterPropertiesSet() {
        if (this.dataSource == null) {
            throw new IllegalStateException("'dataSource' property must be set");
        }
    }
}

