/*
 * Decompiled with CFR 0.152.
 */
package org.jdbi.v3.postgres;

import java.lang.reflect.Type;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.jdbi.v3.core.argument.Argument;
import org.jdbi.v3.core.argument.ArgumentFactory;
import org.jdbi.v3.core.argument.ObjectArgument;
import org.jdbi.v3.core.config.ConfigRegistry;

public class JavaTimeArgumentFactory
implements ArgumentFactory {
    private static final Map<Class<?>, Integer> TYPES;

    public Optional<Argument> build(Type type, Object value, ConfigRegistry config) {
        return Optional.ofNullable(TYPES.get(type)).map(sqlType -> ObjectArgument.of((Object)value, (Integer)sqlType));
    }

    static {
        HashMap<Class, Integer> types = new HashMap<Class, Integer>();
        types.put(LocalDate.class, 91);
        types.put(LocalTime.class, 92);
        types.put(LocalDateTime.class, 93);
        types.put(OffsetDateTime.class, 2014);
        TYPES = Collections.unmodifiableMap(types);
    }
}

