/*
 * Decompiled with CFR 0.152.
 */
package org.jdbi.v3.postgres;

import java.time.Duration;
import org.jdbi.v3.core.argument.AbstractArgumentFactory;
import org.jdbi.v3.core.argument.Argument;
import org.jdbi.v3.core.config.ConfigRegistry;
import org.postgresql.util.PGInterval;

public class DurationArgumentFactory
extends AbstractArgumentFactory<Duration> {
    public DurationArgumentFactory() {
        super(1111);
    }

    public Argument build(Duration duration, ConfigRegistry config) {
        long days;
        Duration d = duration;
        boolean isNegative = d.isNegative();
        if (isNegative) {
            d = d.negated();
        }
        if ((days = d.toDays()) > Integer.MAX_VALUE) {
            throw new IllegalArgumentException(String.format("duration %s too large to be represented unambiguously as postgres interval", d));
        }
        d = d.minusDays(days);
        int hours = (int)d.toHours();
        d = d.minusHours(hours);
        int minutes = (int)d.toMinutes();
        if ((d = d.minusMinutes(minutes)).getNano() % 1000 != 0) {
            throw new IllegalArgumentException(String.format("duration %s too precise to represented as postgres interval", d));
        }
        double seconds = (double)d.getSeconds() + (double)d.getNano() / 1.0E9;
        PGInterval interval = new PGInterval(0, 0, (int)days, hours, minutes, seconds);
        if (isNegative) {
            interval.scale(-1);
        }
        return (i, p, cx) -> p.setObject(i, (Object)interval, 1111);
    }
}

