/*
 * Decompiled with CFR 0.152.
 */
package org.jdbi.v3.postgres;

import java.time.Duration;
import org.jdbi.v3.core.argument.AbstractArgumentFactory;
import org.jdbi.v3.core.argument.Argument;
import org.jdbi.v3.core.config.ConfigRegistry;
import org.postgresql.util.PGInterval;

public class DurationArgumentFactory
extends AbstractArgumentFactory<Duration> {
    public DurationArgumentFactory() {
        super(1111);
    }

    public Argument build(Duration duration, ConfigRegistry config) {
        long days;
        boolean isNegative = duration.isNegative();
        if (isNegative) {
            duration = duration.negated();
        }
        if ((days = duration.toDays()) > Integer.MAX_VALUE) {
            throw new IllegalArgumentException(String.format("duration %s too large to be represented unambiguously as postgres interval", duration));
        }
        duration = duration.minusDays(days);
        int hours = (int)duration.toHours();
        duration = duration.minusHours(hours);
        int minutes = (int)duration.toMinutes();
        if ((duration = duration.minusMinutes(minutes)).getNano() % 1000 != 0) {
            throw new IllegalArgumentException(String.format("duration %s too precise to represented as postgres interval", duration));
        }
        double seconds = (double)duration.getSeconds() + (double)duration.getNano() / 1.0E9;
        PGInterval interval = new PGInterval(0, 0, (int)days, hours, minutes, seconds);
        if (isNegative) {
            interval.scale(-1);
        }
        return (i, p, cx) -> p.setObject(i, (Object)interval, 1111);
    }
}

