/*
 * Decompiled with CFR 0.152.
 */
package org.jdbi.v3.postgres;

import java.lang.reflect.Array;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.util.Arrays;
import java.util.concurrent.CopyOnWriteArraySet;
import org.jdbi.v3.core.StatementContext;
import org.jdbi.v3.core.mapper.ColumnMapper;

public class ArrayColumnMapper
implements ColumnMapper<Object> {
    private static final CopyOnWriteArraySet<Integer> UNSUPPORTED_TYPES = new CopyOnWriteArraySet();
    private final Class<?> componentType;
    private final StatementContext ctx;

    public ArrayColumnMapper(Class<?> componentType, StatementContext ctx) {
        this.componentType = componentType;
        this.ctx = ctx;
    }

    public Object map(ResultSet r, int columnNumber, StatementContext ctx) throws SQLException {
        return this.buildArray(r.getArray(columnNumber));
    }

    private Object buildArray(java.sql.Array array) throws SQLException {
        if (UNSUPPORTED_TYPES.contains(array.getBaseType())) {
            return this.buildFromResultSet(array);
        }
        try {
            Object[] objectArray = (Object[])array.getArray();
            if (this.componentType == Object.class) {
                return objectArray;
            }
            Object componentTypeArray = Array.newInstance(this.componentType, objectArray.length);
            for (int i = 0; i < objectArray.length; ++i) {
                Array.set(componentTypeArray, i, objectArray[i]);
            }
            return componentTypeArray;
        }
        catch (SQLFeatureNotSupportedException e) {
            UNSUPPORTED_TYPES.add(array.getBaseType());
            return this.buildFromResultSet(array);
        }
    }

    private Object[] buildFromResultSet(java.sql.Array array) throws SQLException {
        ColumnMapper mapper = (ColumnMapper)this.ctx.findColumnMapperFor(this.componentType).orElseThrow(() -> new IllegalArgumentException("Unable to find column mapper for " + this.componentType));
        int capacity = 16;
        int length = 0;
        Object[] accumulator = (Object[])Array.newInstance(this.componentType, capacity);
        try (ResultSet rs = array.getResultSet();){
            while (rs.next()) {
                accumulator[length++] = mapper.map(rs, 2, this.ctx);
                if (length != capacity) continue;
                Object[] oldArray = accumulator;
                accumulator = (Object[])Array.newInstance(this.componentType, capacity * 2);
                System.arraycopy(oldArray, 0, accumulator, 0, capacity);
                capacity *= 2;
            }
        }
        if (length == capacity) {
            return accumulator;
        }
        return Arrays.copyOf(accumulator, length);
    }
}

