/*
 * Decompiled with CFR 0.152.
 */
package org.jdbi.v3.postgis;

import java.util.function.Function;
import org.jdbi.v3.core.argument.Argument;
import org.jdbi.v3.core.codec.Codec;
import org.jdbi.v3.core.mapper.ColumnMapper;
import org.jdbi.v3.meta.Alpha;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.io.ParseException;
import org.locationtech.jts.io.WKBReader;
import org.locationtech.jts.io.WKBWriter;

@Alpha
final class PostgisCodec
implements Codec<Geometry> {
    PostgisCodec() {
    }

    public ColumnMapper<Geometry> getColumnMapper() {
        return (resultSet, index, context) -> {
            byte[] bytes = PostgisCodec.hexStringToByteArray(resultSet.getString(index));
            return PostgisCodec.deserialize(bytes);
        };
    }

    public Function<Geometry, Argument> getArgumentFunction() {
        return data -> (position, statement, context) -> statement.setBytes(position, PostgisCodec.serialize(data));
    }

    private static byte[] serialize(Geometry geometry) {
        if (geometry == null) {
            return null;
        }
        WKBWriter writer = new WKBWriter(2, 1, true);
        return writer.write(geometry);
    }

    private static Geometry deserialize(byte[] bytes) {
        if (bytes == null) {
            return null;
        }
        try {
            WKBReader reader = new WKBReader(new GeometryFactory());
            return reader.read(bytes);
        }
        catch (ParseException e) {
            throw new IllegalArgumentException(e);
        }
    }

    private static byte[] hexStringToByteArray(String s) {
        int len = s.length();
        byte[] data = new byte[len / 2];
        for (int i = 0; i < len; i += 2) {
            data[i / 2] = (byte)((Character.digit(s.charAt(i), 16) << 4) + Character.digit(s.charAt(i + 1), 16));
        }
        return data;
    }
}

