/*
 * Decompiled with CFR 0.152.
 */
package org.jdbi.v3.oracle12;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import oracle.jdbc.OraclePreparedStatement;
import org.jdbi.v3.core.result.ResultBearing;
import org.jdbi.v3.core.result.ResultProducer;
import org.jdbi.v3.core.result.ResultSetException;
import org.jdbi.v3.core.statement.StatementContext;
import org.jdbi.v3.core.statement.StatementCustomizer;

public class OracleReturning {
    public static ReturnParameters returnParameters() {
        return new ReturnParameters();
    }

    public static ResultProducer<ResultBearing> returningDml() {
        return (supplier, ctx) -> ResultBearing.of(OracleReturning.getReturnResultSet(supplier, ctx), (StatementContext)ctx);
    }

    private static Supplier<ResultSet> getReturnResultSet(Supplier<PreparedStatement> supplier, StatementContext ctx) {
        return () -> {
            PreparedStatement stmt = (PreparedStatement)supplier.get();
            try {
                if (!stmt.isWrapperFor(OraclePreparedStatement.class)) {
                    throw new IllegalStateException("Statement is not an instance of, nor a wrapper of, OraclePreparedStatement");
                }
                OraclePreparedStatement statement = stmt.unwrap(OraclePreparedStatement.class);
                ResultSet rs = statement.getReturnResultSet();
                if (rs != null) {
                    ctx.addCleanable(rs::close);
                }
                return rs;
            }
            catch (SQLException e) {
                throw new ResultSetException("Unable to retrieve return result set", (Exception)e, ctx);
            }
        };
    }

    public static class ReturnParameters
    implements StatementCustomizer {
        private final List<int[]> binds = new ArrayList<int[]>();

        ReturnParameters() {
        }

        public void beforeExecution(PreparedStatement stmt, StatementContext ctx) throws SQLException {
            if (!stmt.isWrapperFor(OraclePreparedStatement.class)) {
                throw new IllegalStateException("Statement is not an instance of, nor a wrapper of, OraclePreparedStatement");
            }
            OraclePreparedStatement statement = stmt.unwrap(OraclePreparedStatement.class);
            for (int[] bind : this.binds) {
                try {
                    statement.registerReturnParameter(bind[0], bind[1]);
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
        }

        public ReturnParameters register(int index, int oracleType) {
            this.binds.add(new int[]{index + 1, oracleType});
            return this;
        }
    }
}

