/*
 * Decompiled with CFR 0.152.
 */
package org.jdbi.v3.core.kotlin.internal;

import java.lang.reflect.Type;
import java.sql.ResultSet;
import java.util.List;
import java.util.Optional;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmClassMappingKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.KClass;
import kotlin.reflect.KFunction;
import kotlin.reflect.KParameter;
import kotlin.reflect.KType;
import kotlin.reflect.full.KClasses;
import org.jdbi.v3.core.config.ConfigRegistry;
import org.jdbi.v3.core.kotlin.internal.TypeConversionKt;
import org.jdbi.v3.core.mapper.ColumnMapper;
import org.jdbi.v3.core.mapper.ColumnMapperFactory;
import org.jdbi.v3.core.mapper.ColumnMappers;
import org.jdbi.v3.core.mapper.NoSuchMapperException;
import org.jdbi.v3.core.statement.StatementContext;
import org.jdbi.v3.meta.Alpha;
import org.jetbrains.annotations.NotNull;

@Alpha
@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0007\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\"\u0010\u0004\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00060\u00052\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\b\u0010\u000b\u001a\u00020\fH\u0016\u00a8\u0006\r"}, d2={"Lorg/jdbi/v3/core/kotlin/internal/KotlinValueClassColumnMapperFactory;", "Lorg/jdbi/v3/core/mapper/ColumnMapperFactory;", "<init>", "()V", "build", "Ljava/util/Optional;", "Lorg/jdbi/v3/core/mapper/ColumnMapper;", "type", "Ljava/lang/reflect/Type;", "config", "Lorg/jdbi/v3/core/config/ConfigRegistry;", "toString", "", "jdbi3-kotlin"})
public final class KotlinValueClassColumnMapperFactory
implements ColumnMapperFactory {
    @NotNull
    public Optional<ColumnMapper<?>> build(@NotNull Type type, @NotNull ConfigRegistry config) {
        Class clazz;
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        Class clazz2 = type instanceof Class ? (Class)type : null;
        if (clazz2 != null && (clazz2 = JvmClassMappingKt.getKotlinClass((Class)clazz2)) != null) {
            Class it = clazz = clazz2;
            boolean bl = false;
            if (!it.isValue()) {
                Optional<ColumnMapper<?>> optional = Optional.empty();
                Intrinsics.checkNotNullExpressionValue(optional, (String)"empty(...)");
                return optional;
            }
        } else {
            Optional<ColumnMapper<?>> optional = Optional.empty();
            Intrinsics.checkNotNullExpressionValue(optional, (String)"empty(...)");
            return optional;
        }
        Class clazz3 = clazz;
        KFunction kFunction = KClasses.getPrimaryConstructor((KClass)clazz3);
        if (kFunction == null) {
            Optional<ColumnMapper<?>> optional = Optional.empty();
            Intrinsics.checkNotNullExpressionValue(optional, (String)"empty(...)");
            return optional;
        }
        KFunction constructor = kFunction;
        Object object = KClasses.getPrimaryConstructor((KClass)clazz3);
        if (object == null || (object = object.getParameters()) == null || (object = (KParameter)CollectionsKt.singleOrNull((List)object)) == null || (object = object.getType()) == null) {
            Optional<ColumnMapper<?>> optional = Optional.empty();
            Intrinsics.checkNotNullExpressionValue(optional, (String)"empty(...)");
            return optional;
        }
        Object valueParameterType = object;
        Type valueParameterJavaType = TypeConversionKt.toJavaType((KType)valueParameterType);
        ColumnMapper innerMapper = (ColumnMapper)((ColumnMappers)config.get(ColumnMappers.class)).findFor(valueParameterJavaType).orElseThrow(() -> KotlinValueClassColumnMapperFactory.build$lambda$1((KType)valueParameterType, valueParameterJavaType, type));
        Optional<ColumnMapper<?>> optional = Optional.of(new ColumnMapper<Object>(innerMapper, (KFunction<? extends Object>)constructor, (KClass<? extends Object>)clazz3){
            final /* synthetic */ ColumnMapper<?> $innerMapper;
            final /* synthetic */ KFunction<Object> $constructor;
            final /* synthetic */ KClass<? extends Object> $clazz;
            {
                this.$innerMapper = $innerMapper;
                this.$constructor = $constructor;
                this.$clazz = $clazz;
            }

            public Object map(ResultSet rs, int columnNumber, StatementContext ctx) {
                Object object;
                Intrinsics.checkNotNullParameter((Object)rs, (String)"rs");
                Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
                Object innerValue = this.$innerMapper.map(rs, columnNumber, ctx);
                if (!rs.wasNull()) {
                    Object[] objectArray = new Object[]{innerValue};
                    object = this.$constructor.call(objectArray);
                } else {
                    object = null;
                }
                return object;
            }

            public String toString() {
                return "KotlinValueClassColumnMapper(kClass = " + this.$clazz + ")";
            }
        });
        Intrinsics.checkNotNullExpressionValue(optional, (String)"of(...)");
        return optional;
    }

    @NotNull
    public String toString() {
        return "KotlinValueClassColumnMapperFactory";
    }

    private static final NoSuchMapperException build$lambda$1(KType $valueParameterType, Type $valueParameterJavaType, Type $type) {
        return new NoSuchMapperException("No column mapper registered for parameter (kotlin: " + $valueParameterType + ", java: " + $valueParameterJavaType + ") of type " + $type);
    }
}

