/*
 * Decompiled with CFR 0.152.
 */
package org.jdbi.v3.json.internal;

import java.lang.reflect.Type;
import java.util.Optional;
import java.util.function.Supplier;
import org.jdbi.v3.core.config.ConfigRegistry;
import org.jdbi.v3.core.internal.JdbiOptionals;
import org.jdbi.v3.core.mapper.ColumnMapper;
import org.jdbi.v3.core.mapper.ColumnMapperFactory;
import org.jdbi.v3.core.qualifier.QualifiedType;
import org.jdbi.v3.core.result.UnableToProduceResultException;
import org.jdbi.v3.json.Json;
import org.jdbi.v3.json.JsonConfig;

@Json
public class JsonColumnMapperFactory
implements ColumnMapperFactory {
    private static final String JSON_NOT_RETRIEVABLE = String.format("No column mapper found for '@%s String', or 'String'", Json.class.getSimpleName());

    public Optional<ColumnMapper<?>> build(Type type, ConfigRegistry config) {
        if (String.class.equals((Object)type)) {
            return Optional.empty();
        }
        return Optional.of((rs, i, ctx) -> {
            ColumnMapper jsonStringMapper = (ColumnMapper)JdbiOptionals.findFirstPresent((Supplier[])new Supplier[]{() -> ctx.findColumnMapperFor(QualifiedType.of(String.class).with(new Class[]{Json.class})), () -> ctx.findColumnMapperFor(String.class)}).orElseThrow(() -> new UnableToProduceResultException(JSON_NOT_RETRIEVABLE, ctx));
            String json = (String)jsonStringMapper.map(rs, i, ctx);
            return json == null ? null : ((JsonConfig)ctx.getConfig(JsonConfig.class)).getJsonMapper().fromJson(type, json, ctx);
        });
    }
}

