/*
 * Decompiled with CFR 0.152.
 */
package org.jdbi.v3.json.internal;

import java.lang.reflect.Type;
import java.util.Optional;
import java.util.function.Supplier;
import org.jdbi.v3.core.argument.Argument;
import org.jdbi.v3.core.argument.ArgumentFactory;
import org.jdbi.v3.core.config.ConfigRegistry;
import org.jdbi.v3.core.internal.JdbiOptionals;
import org.jdbi.v3.core.qualifier.QualifiedType;
import org.jdbi.v3.core.statement.UnableToCreateStatementException;
import org.jdbi.v3.json.Json;
import org.jdbi.v3.json.JsonConfig;

@Json
public class JsonArgumentFactory
implements ArgumentFactory {
    private static final String JSON_NOT_STORABLE = String.format("No argument factory found for `@%s String` or 'String'", Json.class.getSimpleName());

    public Optional<Argument> build(Type type, Object value, ConfigRegistry config) {
        if (String.class.equals((Object)type)) {
            return Optional.empty();
        }
        return Optional.of((pos, stmt, ctx) -> {
            String json = value == null ? null : ((JsonConfig)ctx.getConfig(JsonConfig.class)).getJsonMapper().toJson(type, value, ctx);
            Argument stringBinder = (Argument)JdbiOptionals.findFirstPresent((Supplier[])new Supplier[]{() -> ctx.findArgumentFor(QualifiedType.of(String.class).with(new Class[]{Json.class}), (Object)json), () -> ctx.findArgumentFor(String.class, (Object)json)}).orElseThrow(() -> new UnableToCreateStatementException(JSON_NOT_STORABLE));
            stringBinder.apply(pos, stmt, ctx);
        });
    }
}

