/*
 * Decompiled with CFR 0.152.
 */
package org.jdbi.v3.jpa.internal;

import java.beans.PropertyDescriptor;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.lang.reflect.Type;
import java.util.Objects;
import java.util.Optional;
import javax.persistence.Column;
import org.jdbi.v3.core.qualifier.QualifiedType;
import org.jdbi.v3.core.qualifier.Qualifiers;
import org.jdbi.v3.jpa.EntityMemberAccessException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JpaMember {
    private static final Qualifiers QUALIFIERS = new Qualifiers();
    private static final Logger LOGGER = LoggerFactory.getLogger(JpaMember.class);
    private final Class<?> clazz;
    private final String columnName;
    private final QualifiedType<?> qualifiedType;
    private final Getter accessor;
    private final Setter mutator;

    JpaMember(Class<?> clazz, Column column, Field field) {
        this.clazz = Objects.requireNonNull(clazz);
        this.columnName = JpaMember.nameOf(column, field.getName());
        this.qualifiedType = QualifiedType.of((Type)field.getGenericType()).withAnnotations((Iterable)QUALIFIERS.findFor(new AnnotatedElement[]{field}));
        field.setAccessible(true);
        this.accessor = field::get;
        this.mutator = field::set;
    }

    JpaMember(Class<?> clazz, Column column, PropertyDescriptor property) {
        this.clazz = Objects.requireNonNull(clazz);
        this.columnName = JpaMember.nameOf(column, property.getName());
        Method getter = property.getReadMethod();
        Method setter = property.getWriteMethod();
        Parameter setterParam = setter.getParameters()[0];
        getter.setAccessible(true);
        setter.setAccessible(true);
        this.qualifiedType = QualifiedType.of((Type)getter.getGenericReturnType()).withAnnotations((Iterable)QUALIFIERS.findFor(new AnnotatedElement[]{getter, setter, setterParam}));
        Method method = getter;
        Objects.requireNonNull(method);
        Method method2 = method;
        this.accessor = x$0 -> method2.invoke(x$0, new Object[0]);
        Method method3 = setter;
        Objects.requireNonNull(method3);
        method2 = method3;
        this.mutator = (x$0, xva$1) -> method2.invoke(x$0, xva$1);
    }

    public String getColumnName() {
        return this.columnName;
    }

    public QualifiedType<?> getQualifiedType() {
        return this.qualifiedType;
    }

    public Type getType() {
        return this.qualifiedType.getType();
    }

    public Object read(Object obj) throws IllegalAccessException, InvocationTargetException {
        return this.accessor.get(obj);
    }

    public void write(Object obj, Object value) {
        LOGGER.debug("write {}/{}/{}/{}", new Object[]{this.clazz, this.columnName, this.qualifiedType, value});
        try {
            this.mutator.set(obj, value);
        }
        catch (ReflectiveOperationException e) {
            throw new EntityMemberAccessException("Couldn't set " + String.valueOf(this.clazz) + "#" + this.columnName, e);
        }
    }

    private static String nameOf(Column column, String memberName) {
        return Optional.ofNullable(column).map(Column::name).filter(name -> name.length() > 0).orElse(memberName);
    }

    @FunctionalInterface
    static interface Getter {
        public Object get(Object var1) throws IllegalAccessException, InvocationTargetException;
    }

    @FunctionalInterface
    static interface Setter {
        public void set(Object var1, Object var2) throws IllegalAccessException, InvocationTargetException;
    }
}

