/*
 * Decompiled with CFR 0.152.
 */
package org.jdbi.v3.jpa;

import java.beans.IndexedPropertyDescriptor;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.WeakHashMap;
import java.util.stream.Stream;
import javax.persistence.Column;
import javax.persistence.MappedSuperclass;
import org.jdbi.v3.jpa.JpaMember;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class JpaClass<C> {
    private static final Map<Class<?>, JpaClass<?>> cache = Collections.synchronizedMap(new WeakHashMap());
    private final List<JpaMember> members;
    private static final Logger logger = LoggerFactory.getLogger(JpaClass.class);

    public static <C> JpaClass<C> get(Class<C> clazz) {
        return cache.computeIfAbsent(clazz, JpaClass::new);
    }

    private JpaClass(Class<C> clazz) {
        this.members = Collections.unmodifiableList(new ArrayList<JpaMember>(JpaClass.inspectClass(clazz)));
        logger.debug("init {}: {} members.", clazz, (Object)this.members.size());
    }

    private static Collection<JpaMember> inspectClass(Class<?> clazz) {
        HashMap<String, JpaMember> members = new HashMap<String, JpaMember>();
        JpaClass.inspectFields(clazz, members);
        JpaClass.inspectAnnotatedProperties(clazz, members);
        JpaClass.inspectSuperclasses(clazz, members);
        JpaClass.inspectNonAnnotatedProperties(clazz, members);
        return members.values();
    }

    private static void inspectSuperclasses(Class<?> clazz, Map<String, JpaMember> members) {
        while ((clazz = clazz.getSuperclass()) != null) {
            if (!clazz.isAnnotationPresent(MappedSuperclass.class)) continue;
            JpaClass.inspectFields(clazz, members);
        }
    }

    private static void inspectFields(Class<?> clazz, Map<String, JpaMember> members) {
        for (Field member : clazz.getDeclaredFields()) {
            Column column;
            if (members.containsKey(member.getName()) || (column = member.getAnnotation(Column.class)) == null) continue;
            members.put(member.getName(), new JpaMember(clazz, column, member));
        }
    }

    private static void inspectAnnotatedProperties(Class<?> clazz, Map<String, JpaMember> members) {
        JpaClass.inspectProperties(clazz, members, true);
    }

    private static void inspectNonAnnotatedProperties(Class<?> clazz, Map<String, JpaMember> members) {
        JpaClass.inspectProperties(clazz, members, false);
    }

    private static void inspectProperties(Class<?> clazz, Map<String, JpaMember> members, boolean hasColumnAnnotation) {
        try {
            Stream.of(Introspector.getBeanInfo(clazz).getPropertyDescriptors()).filter(property -> !members.containsKey(property.getName())).filter(property -> !(property instanceof IndexedPropertyDescriptor)).filter(property -> !"class".equals(property.getName())).forEach(property -> {
                Method setter;
                Method getter = property.getReadMethod();
                Column column = Stream.of(getter, setter = property.getWriteMethod()).filter(Objects::nonNull).map(method -> method.getAnnotation(Column.class)).filter(Objects::nonNull).findFirst().orElse(null);
                if (column != null == hasColumnAnnotation) {
                    members.put(property.getName(), new JpaMember(clazz, column, (PropertyDescriptor)property));
                }
            });
        }
        catch (IntrospectionException e) {
            logger.warn("Unable to introspect " + clazz, (Throwable)e);
        }
    }

    public JpaMember lookupMember(String columnLabel) {
        String column = columnLabel.toLowerCase(Locale.ROOT);
        return this.members.stream().filter(member -> column.equals(member.getColumnName().toLowerCase(Locale.ROOT))).findFirst().orElse(null);
    }

    public List<JpaMember> members() {
        return this.members;
    }
}

