/*
 * Decompiled with CFR 0.152.
 */
package org.jdbi.v3.jpa;

import java.lang.annotation.Annotation;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import org.jdbi.v3.jpa.EntityMemberAccessException;
import org.jdbi.v3.jpa.JpaClass;
import org.jdbi.v3.jpa.JpaMember;
import org.jdbi.v3.sqlobject.customizer.SqlStatementCustomizerFactory;
import org.jdbi.v3.sqlobject.customizer.SqlStatementCustomizingAnnotation;
import org.jdbi.v3.sqlobject.customizer.SqlStatementParameterCustomizer;

@Retention(value=RetentionPolicy.RUNTIME)
@Target(value={ElementType.PARAMETER})
@SqlStatementCustomizingAnnotation(value=Factory.class)
public @interface BindJpa {
    public String value() default "";

    public static class Factory
    implements SqlStatementCustomizerFactory {
        public SqlStatementParameterCustomizer createForParameter(Annotation annotation, Class<?> sqlObjectType, Method method, Parameter param, int index) {
            BindJpa bind = (BindJpa)annotation;
            String prefix = bind.value().isEmpty() ? "" : bind.value() + ".";
            return (stmt, arg) -> {
                JpaClass<?> jpaClass = JpaClass.get(arg.getClass());
                for (JpaMember member : jpaClass.members()) {
                    stmt.bindByType(prefix + member.getColumnName(), Factory.readMember(arg, member), member.getType());
                }
            };
        }

        private static Object readMember(Object entity, JpaMember member) {
            try {
                return member.read(entity);
            }
            catch (IllegalAccessException e) {
                String message = String.format("Unable to access property value for column %s", member.getColumnName());
                throw new EntityMemberAccessException(message, e);
            }
            catch (InvocationTargetException e) {
                String message = String.format("Exception thrown in accessor method for column %s", member.getColumnName());
                throw new EntityMemberAccessException(message, e);
            }
        }
    }
}

