/*
 * Decompiled with CFR 0.152.
 */
package org.jdbi.v3.jpa;

import java.lang.reflect.Constructor;
import java.lang.reflect.Type;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import org.jdbi.v3.core.mapper.ColumnMapper;
import org.jdbi.v3.core.mapper.NoSuchMapperException;
import org.jdbi.v3.core.mapper.RowMapper;
import org.jdbi.v3.core.statement.StatementContext;
import org.jdbi.v3.jpa.EntityMemberAccessException;
import org.jdbi.v3.jpa.JpaClass;
import org.jdbi.v3.jpa.JpaMember;

public class JpaMapper<C>
implements RowMapper<C> {
    private final Class<C> clazz;
    private final JpaClass<C> jpaClass;

    JpaMapper(Class<C> clazz) {
        this.clazz = clazz;
        this.jpaClass = JpaClass.get(clazz);
    }

    public RowMapper<C> specialize(ResultSet rs, StatementContext ctx) throws SQLException {
        Constructor constructor;
        try {
            constructor = this.clazz.getDeclaredConstructor(new Class[0]);
        }
        catch (ReflectiveOperationException e) {
            throw new EntityMemberAccessException("Unable to get constructor for " + this.clazz, e);
        }
        constructor.setAccessible(true);
        ArrayList<MemberSetter<Object>> setters = new ArrayList<MemberSetter<Object>>();
        for (int colIndex = rs.getMetaData().getColumnCount(); colIndex >= 1; --colIndex) {
            String columnLabel = rs.getMetaData().getColumnLabel(colIndex);
            JpaMember member = this.jpaClass.lookupMember(columnLabel);
            if (member == null) continue;
            Type memberType = member.getType();
            ColumnMapper columnMapper = (ColumnMapper)ctx.findColumnMapperFor(memberType).orElseThrow(() -> new NoSuchMapperException("No column mapper for " + memberType));
            int columnIndex = colIndex;
            setters.add(obj -> member.write(obj, columnMapper.map(rs, columnIndex, ctx)));
        }
        return (r, c) -> {
            Object obj;
            try {
                obj = constructor.newInstance(new Object[0]);
            }
            catch (ReflectiveOperationException e) {
                throw new EntityMemberAccessException("Unable to invoke " + constructor, e);
            }
            for (MemberSetter setter : setters) {
                setter.mapAndSetMember(obj);
            }
            return obj;
        };
    }

    public C map(ResultSet rs, StatementContext ctx) throws SQLException {
        return (C)this.specialize(rs, ctx).map(rs, ctx);
    }

    @FunctionalInterface
    private static interface MemberSetter<C> {
        public void mapAndSetMember(C var1) throws SQLException;
    }
}

