/*
 * Decompiled with CFR 0.152.
 */
package org.jdbi.v3.jpa;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Type;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.jdbi.v3.core.StatementContext;
import org.jdbi.v3.core.mapper.ColumnMapper;
import org.jdbi.v3.core.mapper.RowMapper;
import org.jdbi.v3.jpa.EntityMemberAccessException;
import org.jdbi.v3.jpa.JpaClass;
import org.jdbi.v3.jpa.JpaMember;
import org.jdbi.v3.jpa.NoSuchColumnMapperException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JpaMapper<C>
implements RowMapper<C> {
    private final Class<C> clazz;
    private final JpaClass<C> jpaClass;
    private static final Logger logger = LoggerFactory.getLogger(JpaMapper.class);

    JpaMapper(Class<C> clazz) {
        logger.debug("init {}", clazz);
        this.clazz = clazz;
        this.jpaClass = JpaClass.get(clazz);
    }

    public C map(ResultSet rs, StatementContext ctx) throws SQLException {
        logger.debug("map {}", this.clazz);
        try {
            return this.tryMap(rs, ctx);
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new EntityMemberAccessException(String.format("Unable to map %s entity", this.clazz), e);
        }
    }

    private C tryMap(ResultSet rs, StatementContext ctx) throws NoSuchMethodException, InstantiationException, IllegalAccessException, InvocationTargetException, SQLException {
        Constructor<C> constructor = this.clazz.getDeclaredConstructor(new Class[0]);
        constructor.setAccessible(true);
        C obj = constructor.newInstance(new Object[0]);
        for (int colIndex = rs.getMetaData().getColumnCount(); colIndex >= 1; --colIndex) {
            String columnLabel = rs.getMetaData().getColumnLabel(colIndex);
            JpaMember member = this.jpaClass.lookupMember(columnLabel);
            if (member == null) continue;
            Type memberType = member.getType();
            ColumnMapper columnMapper = (ColumnMapper)ctx.findColumnMapperFor(memberType).orElseThrow(() -> new NoSuchColumnMapperException("No column mapper for " + memberType));
            Object value = columnMapper.map(rs, columnLabel, ctx);
            member.write(obj, value);
        }
        return obj;
    }
}

