/*
 * Decompiled with CFR 0.152.
 */
package org.jdbi.v3.jpa;

import java.lang.reflect.InvocationTargetException;
import org.jdbi.v3.jpa.BindJpa;
import org.jdbi.v3.jpa.EntityMemberAccessException;
import org.jdbi.v3.jpa.JpaClass;
import org.jdbi.v3.jpa.JpaMember;
import org.jdbi.v3.sqlobject.Binder;
import org.jdbi.v3.sqlobject.BinderFactory;

public class BindJpaFactory
implements BinderFactory<BindJpa, Object> {
    public Binder<BindJpa, Object> build(BindJpa annotation) {
        return (q, parameter, index, bind, arg) -> {
            String prefix = "___jdbi_bare___".equals(bind.value()) ? "" : bind.value() + ".";
            JpaClass<?> jpaClass = JpaClass.get(arg.getClass());
            for (JpaMember member : jpaClass.members()) {
                q.bindByType(prefix + member.getColumnName(), BindJpaFactory.readMember(arg, member), member.getType());
            }
        };
    }

    private static Object readMember(Object entity, JpaMember member) {
        try {
            return member.read(entity);
        }
        catch (IllegalAccessException e) {
            String message = String.format("Unable to access property value for column %s", member.getColumnName());
            throw new EntityMemberAccessException(message, e);
        }
        catch (InvocationTargetException e) {
            String message = String.format("Exception thrown in accessor method for column %s", member.getColumnName());
            throw new EntityMemberAccessException(message, e);
        }
    }
}

