/*
 * Decompiled with CFR 0.152.
 */
package org.jdbi.v3.guice.internal;

import com.google.common.base.Preconditions;
import com.google.inject.Binder;
import com.google.inject.TypeLiteral;
import com.google.inject.binder.LinkedBindingBuilder;
import com.google.inject.multibindings.MapBinder;
import com.google.inject.multibindings.Multibinder;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import org.jdbi.v3.core.codec.Codec;
import org.jdbi.v3.core.generic.GenericType;
import org.jdbi.v3.core.mapper.ColumnMapper;
import org.jdbi.v3.core.mapper.RowMapper;
import org.jdbi.v3.core.qualifier.QualifiedType;
import org.jdbi.v3.core.spi.JdbiPlugin;
import org.jdbi.v3.guice.GuiceJdbiCustomizer;
import org.jdbi.v3.guice.JdbiBinder;

public final class InternalJdbiBinder
implements JdbiBinder {
    private final Multibinder<RowMapper<?>> rowMapperBinder;
    private final MapBinder<Type, RowMapper<?>> qualifiedRowMapperBinder;
    private final Multibinder<ColumnMapper<?>> columnMapperBinder;
    private final MapBinder<QualifiedType<?>, ColumnMapper<?>> qualifiedColumnMapperBinder;
    private final MapBinder<QualifiedType<?>, Codec<?>> codecBinder;
    private final MapBinder<Class<?>, String> arrayTypeBinder;
    private final Multibinder<JdbiPlugin> pluginBinder;
    private final Multibinder<GuiceJdbiCustomizer> customizerBinder;

    public static InternalJdbiBinder jdbiBinder(Binder binder) {
        return new InternalJdbiBinder(binder);
    }

    public static InternalJdbiBinder jdbiBinder(Binder binder, Class<? extends Annotation> annotationClass) {
        return new InternalJdbiBinder(binder, annotationClass);
    }

    private InternalJdbiBinder(Binder binder) {
        Binder b = ((Binder)Preconditions.checkNotNull((Object)binder, (Object)"binder is null")).skipSources(new Class[]{this.getClass()});
        this.rowMapperBinder = Multibinder.newSetBinder((Binder)b, (TypeLiteral)new TypeLiteral<RowMapper<?>>(){});
        this.qualifiedRowMapperBinder = MapBinder.newMapBinder((Binder)b, (TypeLiteral)new TypeLiteral<Type>(){}, (TypeLiteral)new TypeLiteral<RowMapper<?>>(){});
        this.columnMapperBinder = Multibinder.newSetBinder((Binder)b, (TypeLiteral)new TypeLiteral<ColumnMapper<?>>(){});
        this.qualifiedColumnMapperBinder = MapBinder.newMapBinder((Binder)b, (TypeLiteral)new TypeLiteral<QualifiedType<?>>(){}, (TypeLiteral)new TypeLiteral<ColumnMapper<?>>(){});
        this.codecBinder = MapBinder.newMapBinder((Binder)b, (TypeLiteral)new TypeLiteral<QualifiedType<?>>(){}, (TypeLiteral)new TypeLiteral<Codec<?>>(){});
        this.arrayTypeBinder = MapBinder.newMapBinder((Binder)b, (TypeLiteral)new TypeLiteral<Class<?>>(){}, (TypeLiteral)new TypeLiteral<String>(){});
        this.pluginBinder = Multibinder.newSetBinder((Binder)b, (TypeLiteral)new TypeLiteral<JdbiPlugin>(){});
        this.customizerBinder = Multibinder.newSetBinder((Binder)b, (TypeLiteral)new TypeLiteral<GuiceJdbiCustomizer>(){});
    }

    private InternalJdbiBinder(Binder binder, Class<? extends Annotation> a) {
        Binder b = ((Binder)Preconditions.checkNotNull((Object)binder, (Object)"binder is null")).skipSources(new Class[]{this.getClass()});
        this.rowMapperBinder = Multibinder.newSetBinder((Binder)b, (TypeLiteral)new TypeLiteral<RowMapper<?>>(){}, a);
        this.qualifiedRowMapperBinder = MapBinder.newMapBinder((Binder)b, (TypeLiteral)new TypeLiteral<Type>(){}, (TypeLiteral)new TypeLiteral<RowMapper<?>>(){}, a);
        this.columnMapperBinder = Multibinder.newSetBinder((Binder)b, (TypeLiteral)new TypeLiteral<ColumnMapper<?>>(){}, a);
        this.qualifiedColumnMapperBinder = MapBinder.newMapBinder((Binder)b, (TypeLiteral)new TypeLiteral<QualifiedType<?>>(){}, (TypeLiteral)new TypeLiteral<ColumnMapper<?>>(){}, a);
        this.codecBinder = MapBinder.newMapBinder((Binder)b, (TypeLiteral)new TypeLiteral<QualifiedType<?>>(){}, (TypeLiteral)new TypeLiteral<Codec<?>>(){}, a);
        this.arrayTypeBinder = MapBinder.newMapBinder((Binder)b, (TypeLiteral)new TypeLiteral<Class<?>>(){}, (TypeLiteral)new TypeLiteral<String>(){}, a);
        this.pluginBinder = Multibinder.newSetBinder((Binder)b, (TypeLiteral)new TypeLiteral<JdbiPlugin>(){}, a);
        this.customizerBinder = Multibinder.newSetBinder((Binder)b, (TypeLiteral)new TypeLiteral<GuiceJdbiCustomizer>(){}, a);
    }

    @Override
    public LinkedBindingBuilder<RowMapper<?>> bindRowMapper() {
        return this.rowMapperBinder.addBinding();
    }

    @Override
    public LinkedBindingBuilder<RowMapper<?>> bindRowMapper(GenericType<?> genericType) {
        Preconditions.checkNotNull(genericType, (Object)"genericType is null");
        return this.qualifiedRowMapperBinder.addBinding((Object)genericType.getType());
    }

    @Override
    public LinkedBindingBuilder<RowMapper<?>> bindRowMapper(Type type) {
        Preconditions.checkNotNull((Object)type, (Object)"type is null");
        return this.qualifiedRowMapperBinder.addBinding((Object)type);
    }

    @Override
    public LinkedBindingBuilder<ColumnMapper<?>> bindColumnMapper() {
        return this.columnMapperBinder.addBinding();
    }

    @Override
    public LinkedBindingBuilder<ColumnMapper<?>> bindColumnMapper(QualifiedType<?> qualifiedType) {
        Preconditions.checkNotNull(qualifiedType, (Object)"qualifiedType is null");
        return this.qualifiedColumnMapperBinder.addBinding(qualifiedType);
    }

    @Override
    public LinkedBindingBuilder<ColumnMapper<?>> bindColumnMapper(GenericType<?> genericType) {
        Preconditions.checkNotNull(genericType, (Object)"genericType is null");
        return this.qualifiedColumnMapperBinder.addBinding((Object)QualifiedType.of((Type)genericType.getType()));
    }

    @Override
    public LinkedBindingBuilder<ColumnMapper<?>> bindColumnMapper(Type type) {
        Preconditions.checkNotNull((Object)type, (Object)"type is null");
        return this.qualifiedColumnMapperBinder.addBinding((Object)QualifiedType.of((Type)type));
    }

    @Override
    public LinkedBindingBuilder<String> bindArrayType(Class<?> arrayType) {
        Preconditions.checkNotNull(arrayType, (Object)"arrayType is null");
        return this.arrayTypeBinder.addBinding(arrayType);
    }

    @Override
    public LinkedBindingBuilder<Codec<?>> bindCodec(QualifiedType<?> qualifiedType) {
        Preconditions.checkNotNull(qualifiedType, (Object)"qualifiedType is null");
        return this.codecBinder.addBinding(qualifiedType);
    }

    @Override
    public LinkedBindingBuilder<Codec<?>> bindCodec(GenericType<?> genericType) {
        Preconditions.checkNotNull(genericType, (Object)"genericType is null");
        return this.codecBinder.addBinding((Object)QualifiedType.of((Type)genericType.getType()));
    }

    @Override
    public LinkedBindingBuilder<Codec<?>> bindCodec(Type type) {
        Preconditions.checkNotNull((Object)type, (Object)"type is null");
        return this.codecBinder.addBinding((Object)QualifiedType.of((Type)type));
    }

    @Override
    public LinkedBindingBuilder<JdbiPlugin> bindPlugin() {
        return this.pluginBinder.addBinding();
    }

    @Override
    public LinkedBindingBuilder<GuiceJdbiCustomizer> bindCustomizer() {
        return this.customizerBinder.addBinding();
    }
}

