/*
 * Decompiled with CFR 0.152.
 */
package org.jdbi.v3.guice.internal;

import com.google.common.base.Preconditions;
import com.google.inject.Key;
import com.google.inject.PrivateModule;
import com.google.inject.Scopes;
import com.google.inject.TypeLiteral;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.jdbi.v3.core.codec.Codec;
import org.jdbi.v3.core.mapper.ColumnMapper;
import org.jdbi.v3.core.mapper.RowMapper;
import org.jdbi.v3.core.qualifier.QualifiedType;
import org.jdbi.v3.core.spi.JdbiPlugin;
import org.jdbi.v3.guice.GuiceJdbiCustomizer;
import org.jdbi.v3.guice.internal.InternalGuiceJdbiCustomizer;

public final class InternalGlobalJdbiModule
extends PrivateModule {
    private static final TypeLiteral<Set<RowMapper<?>>> ROW_MAPPER_TYPE_LITERAL = new TypeLiteral<Set<RowMapper<?>>>(){};
    private static final TypeLiteral<Map<Type, RowMapper<?>>> QUALIFIED_ROW_MAPPER_TYPE_LITERAL = new TypeLiteral<Map<Type, RowMapper<?>>>(){};
    private static final TypeLiteral<Set<ColumnMapper<?>>> COLUMN_MAPPER_TYPE_LITERAL = new TypeLiteral<Set<ColumnMapper<?>>>(){};
    private static final TypeLiteral<Map<QualifiedType<?>, ColumnMapper<?>>> QUALIFIED_COLUMN_MAPPER_TYPE_LITERAL = new TypeLiteral<Map<QualifiedType<?>, ColumnMapper<?>>>(){};
    private static final TypeLiteral<Set<GuiceJdbiCustomizer>> CUSTOMIZER_TYPE_LITERAL = new TypeLiteral<Set<GuiceJdbiCustomizer>>(){};
    private static final TypeLiteral<Map<Class<?>, String>> ARRAY_TYPES_TYPE_LITERAL = new TypeLiteral<Map<Class<?>, String>>(){};
    private static final TypeLiteral<Set<JdbiPlugin>> PLUGINS_TYPE_LITERAL = new TypeLiteral<Set<JdbiPlugin>>(){};
    private static final TypeLiteral<Map<QualifiedType<?>, Codec<?>>> CODECS_TYPE_LITERAL = new TypeLiteral<Map<QualifiedType<?>, Codec<?>>>(){};
    private static final ConcurrentHashMap<Class<? extends Annotation>, InternalGlobalJdbiModule> REGISTRY = new ConcurrentHashMap();
    private final Class<? extends Annotation> annotation;

    public static InternalGlobalJdbiModule forAnnotation(Class<? extends Annotation> annotation) {
        Preconditions.checkNotNull(annotation, (Object)"annotation is null");
        return REGISTRY.computeIfAbsent(annotation, InternalGlobalJdbiModule::new);
    }

    private InternalGlobalJdbiModule(Class<? extends Annotation> annotation) {
        this.annotation = (Class)Preconditions.checkNotNull(annotation, (Object)"annotation is null");
    }

    public void configure() {
        this.binder().bind(ROW_MAPPER_TYPE_LITERAL).to(Key.get(ROW_MAPPER_TYPE_LITERAL, this.annotation));
        this.binder().bind(QUALIFIED_ROW_MAPPER_TYPE_LITERAL).to(Key.get(QUALIFIED_ROW_MAPPER_TYPE_LITERAL, this.annotation));
        this.binder().bind(COLUMN_MAPPER_TYPE_LITERAL).to(Key.get(COLUMN_MAPPER_TYPE_LITERAL, this.annotation));
        this.binder().bind(QUALIFIED_COLUMN_MAPPER_TYPE_LITERAL).to(Key.get(QUALIFIED_COLUMN_MAPPER_TYPE_LITERAL, this.annotation));
        this.binder().bind(CUSTOMIZER_TYPE_LITERAL).to(Key.get(CUSTOMIZER_TYPE_LITERAL, this.annotation));
        this.binder().bind(PLUGINS_TYPE_LITERAL).to(Key.get(PLUGINS_TYPE_LITERAL, this.annotation));
        this.binder().bind(ARRAY_TYPES_TYPE_LITERAL).to(Key.get(ARRAY_TYPES_TYPE_LITERAL, this.annotation));
        this.binder().bind(CODECS_TYPE_LITERAL).to(Key.get(CODECS_TYPE_LITERAL, this.annotation));
        this.binder().bind(GuiceJdbiCustomizer.class).annotatedWith(this.annotation).to(InternalGuiceJdbiCustomizer.class).in(Scopes.SINGLETON);
        this.expose(Key.get(GuiceJdbiCustomizer.class, this.annotation));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        InternalGlobalJdbiModule that = (InternalGlobalJdbiModule)((Object)o);
        return this.annotation.equals(that.annotation);
    }

    public int hashCode() {
        return Objects.hash(this.annotation);
    }
}

