/*
 * Decompiled with CFR 0.152.
 */
package org.jdbi.v3.guice.internal;

import com.google.common.base.Preconditions;
import com.google.inject.Inject;
import com.google.inject.Injector;
import com.google.inject.Key;
import com.google.inject.Provider;
import com.google.inject.Scope;
import com.google.inject.TypeLiteral;
import com.google.inject.binder.LinkedBindingBuilder;
import com.google.inject.binder.ScopedBindingBuilder;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import java.lang.annotation.Annotation;

public final class InternalImportBindingBuilder<T>
implements ScopedBindingBuilder {
    private final Key<T> concreteType;
    private final ScopedBindingBuilder binder;
    private final InternalBindingProvider<T> provider;

    public InternalImportBindingBuilder(LinkedBindingBuilder<T> binder, Key<T> concreteType) {
        Preconditions.checkNotNull(binder, (Object)"binder is null");
        this.concreteType = (Key)Preconditions.checkNotNull(concreteType, (Object)"concreteType is null");
        this.provider = new InternalBindingProvider<T>(concreteType);
        this.binder = binder.toProvider(this.provider);
    }

    public ScopedBindingBuilder to(Class<? extends T> clazz) {
        Preconditions.checkNotNull(clazz, (Object)"clazz is null");
        this.provider.setKey(this.concreteType.ofType(clazz));
        return this;
    }

    public ScopedBindingBuilder to(TypeLiteral<? extends T> type) {
        Preconditions.checkNotNull(type, (Object)"type is null");
        this.provider.setKey(this.concreteType.ofType(type));
        return this;
    }

    public void in(Class<? extends Annotation> scopeAnnotation) {
        Preconditions.checkNotNull(scopeAnnotation, (Object)"scopeAnnotation is null");
        this.binder.in(scopeAnnotation);
    }

    public void in(Scope scope) {
        Preconditions.checkNotNull((Object)scope, (Object)"scope is null");
        this.binder.in(scope);
    }

    public void asEagerSingleton() {
        this.binder.asEagerSingleton();
    }

    static final class InternalBindingProvider<T>
    implements Provider<T> {
        private Key<? extends T> key;
        private Injector injector;

        InternalBindingProvider(Key<? extends T> key) {
            this.key = (Key)Preconditions.checkNotNull(key, (Object)"key is null");
        }

        InternalBindingProvider<T> setKey(Key<? extends T> key) {
            this.key = (Key)Preconditions.checkNotNull(key, (Object)"key is null");
            return this;
        }

        @Inject
        void setInjector(Injector injector) {
            Preconditions.checkNotNull((Object)injector, (Object)"injector is null");
            Preconditions.checkState((this.injector == null ? 1 : 0) != 0, (Object)"setInjector() called multiple times!");
            this.injector = injector;
        }

        @CheckForNull
        public T get() {
            Preconditions.checkState((this.injector != null ? 1 : 0) != 0, (Object)"calling get() before setInjector()!");
            return (T)this.injector.getInstance(this.key);
        }
    }
}

