/*
 * Decompiled with CFR 0.152.
 */
package org.jdbi.v3.guice;

import com.google.common.base.Preconditions;
import com.google.inject.Binder;
import com.google.inject.Key;
import com.google.inject.PrivateModule;
import com.google.inject.Scopes;
import com.google.inject.TypeLiteral;
import com.google.inject.binder.LinkedBindingBuilder;
import com.google.inject.multibindings.Multibinder;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.lang.annotation.Annotation;
import javax.sql.DataSource;
import org.jdbi.v3.core.Jdbi;
import org.jdbi.v3.guice.GuiceJdbiCustomizer;
import org.jdbi.v3.guice.JdbiBinder;
import org.jdbi.v3.guice.internal.InternalGuiceJdbiCustomizer;
import org.jdbi.v3.guice.internal.InternalGuiceJdbiFactory;
import org.jdbi.v3.guice.internal.InternalImportBindingBuilder;
import org.jdbi.v3.guice.internal.InternalJdbiBinder;
import org.jdbi.v3.guice.internal.InternalLooseImportBindingBuilder;
import org.jdbi.v3.guice.internal.JdbiGlobal;
import org.jdbi.v3.guice.internal.JdbiInternal;

public abstract class AbstractJdbiDefinitionModule
extends PrivateModule
implements JdbiBinder {
    private final Annotation annotation;
    private final Class<? extends Annotation> annotationClass;
    private final Class<? extends Annotation> globalAnnotationClass;
    private InternalJdbiBinder jdbiBinder;

    public AbstractJdbiDefinitionModule(Annotation annotation) {
        this((Annotation)Preconditions.checkNotNull((Object)annotation, (Object)"annotation is null"), null, JdbiGlobal.class);
    }

    public AbstractJdbiDefinitionModule(Annotation annotation, Class<? extends Annotation> globalAnnotationClass) {
        this((Annotation)Preconditions.checkNotNull((Object)annotation, (Object)"annotation is null"), null, globalAnnotationClass);
    }

    public AbstractJdbiDefinitionModule(Class<? extends Annotation> annotationClass) {
        this(null, (Class)Preconditions.checkNotNull(annotationClass, (Object)"annotationClass is null"), JdbiGlobal.class);
    }

    public AbstractJdbiDefinitionModule(Class<? extends Annotation> annotationClass, Class<? extends Annotation> globalAnnotationClass) {
        this(null, (Class)Preconditions.checkNotNull(annotationClass, (Object)"annotationClass is null"), globalAnnotationClass);
    }

    private AbstractJdbiDefinitionModule(@Nullable Annotation annotation, @Nullable Class<? extends Annotation> annotationClass, @Nullable Class<? extends Annotation> globalAnnotationClass) {
        this.annotation = annotation;
        this.annotationClass = annotationClass;
        this.globalAnnotationClass = globalAnnotationClass;
    }

    protected final void configure() {
        this.jdbiBinder = InternalJdbiBinder.jdbiBinder((Binder)this.binder());
        try {
            Multibinder customizers = Multibinder.newSetBinder((Binder)this.binder(), GuiceJdbiCustomizer.class, JdbiInternal.class);
            if (this.globalAnnotationClass != null) {
                InternalLooseImportBindingBuilder.createLooseBinding(customizers.addBinding(), Key.get(GuiceJdbiCustomizer.class, this.globalAnnotationClass)).withDefault(GuiceJdbiCustomizer.NOP).in(Scopes.SINGLETON);
            }
            customizers.addBinding().to(InternalGuiceJdbiCustomizer.class).in(Scopes.SINGLETON);
            this.importBinding(DataSource.class).in(Scopes.SINGLETON);
            this.bind(Jdbi.class).toProvider(InternalGuiceJdbiFactory.class).in(Scopes.SINGLETON);
            this.exposeBinding(Jdbi.class);
            this.configureJdbi();
        }
        finally {
            this.jdbiBinder = null;
        }
    }

    public abstract void configureJdbi();

    @Override
    public final JdbiBinder jdbiBinder() {
        Preconditions.checkState((this.jdbiBinder != null ? 1 : 0) != 0, (Object)"The jdbiBinder can only be used inside configureJdbi()");
        return this.jdbiBinder;
    }

    public final <T> InternalLooseImportBindingBuilder<T> importBindingLoosely(TypeLiteral<T> type) {
        Preconditions.checkNotNull(type, (Object)"type is null");
        return InternalLooseImportBindingBuilder.createLooseBinding(this.binder().bind(type), this.createKey(type));
    }

    public final <T> InternalLooseImportBindingBuilder<T> importBindingLoosely(Class<T> clazz) {
        Preconditions.checkNotNull(clazz, (Object)"clazz is null");
        return InternalLooseImportBindingBuilder.createLooseBinding(this.binder().bind(clazz), this.createKey(clazz));
    }

    public final <T> InternalLooseImportBindingBuilder<T> importBindingLoosely(LinkedBindingBuilder<T> binder, TypeLiteral<T> type) {
        Preconditions.checkNotNull(binder, (Object)"binder is null");
        Preconditions.checkNotNull(type, (Object)"type is null");
        return InternalLooseImportBindingBuilder.createLooseBinding(binder, this.createKey(type));
    }

    public final <T> InternalLooseImportBindingBuilder<T> importBindingLoosely(LinkedBindingBuilder<T> binder, Class<T> clazz) {
        Preconditions.checkNotNull(binder, (Object)"binder is null");
        Preconditions.checkNotNull(clazz, (Object)"clazz is null");
        return InternalLooseImportBindingBuilder.createLooseBinding(binder, this.createKey(clazz));
    }

    public final <T> InternalImportBindingBuilder<T> importBinding(Class<T> clazz) {
        Preconditions.checkNotNull(clazz, (Object)"clazz is null");
        return new InternalImportBindingBuilder<T>(this.binder().bind(clazz), this.createKey(clazz));
    }

    public final <T> InternalImportBindingBuilder<T> importBinding(TypeLiteral<T> type) {
        Preconditions.checkNotNull(type, (Object)"type is null");
        return new InternalImportBindingBuilder<T>(this.binder().bind(type), this.createKey(type));
    }

    public final <T> InternalImportBindingBuilder<T> importBinding(LinkedBindingBuilder<T> binder, TypeLiteral<T> type) {
        Preconditions.checkNotNull(binder, (Object)"binder is null");
        Preconditions.checkNotNull(type, (Object)"type is null");
        return new InternalImportBindingBuilder<T>(binder, this.createKey(type));
    }

    public final <T> InternalImportBindingBuilder<T> importBinding(LinkedBindingBuilder<T> binder, Class<T> clazz) {
        Preconditions.checkNotNull(binder, (Object)"binder is null");
        Preconditions.checkNotNull(clazz, (Object)"clazz is null");
        return new InternalImportBindingBuilder<T>(binder, this.createKey(clazz));
    }

    public final <T> Key<T> createKey(Class<T> clazz) {
        Preconditions.checkNotNull(clazz, (Object)"clazz is null");
        return this.createKey(TypeLiteral.get(clazz));
    }

    public final <T> Key<T> createKey(TypeLiteral<T> type) {
        Preconditions.checkNotNull(type, (Object)"type is null");
        if (this.annotation != null) {
            return Key.get(type, (Annotation)this.annotation);
        }
        if (this.annotationClass != null) {
            return Key.get(type, this.annotationClass);
        }
        throw new IllegalStateException("Neither annotation or annotation class found!");
    }

    public final <T> void exposeBinding(Class<T> clazz) {
        Preconditions.checkNotNull(clazz, (Object)"clazz is null");
        this.exposeBinding(TypeLiteral.get(clazz));
    }

    public final <T> void exposeBinding(TypeLiteral<T> type) {
        Preconditions.checkNotNull(type, (Object)"type is null");
        Key<T> key = this.createKey(type);
        this.bind(key).to(type).in(Scopes.SINGLETON);
        this.expose(key);
    }
}

