/*
 * Decompiled with CFR 0.152.
 */
package org.jdbi.v3.guice;

import com.google.common.base.Preconditions;
import com.google.inject.AbstractModule;
import com.google.inject.Module;
import java.lang.annotation.Annotation;
import org.jdbi.v3.guice.JdbiBinder;
import org.jdbi.v3.guice.internal.InternalGlobalJdbiModule;
import org.jdbi.v3.guice.internal.InternalJdbiBinder;
import org.jdbi.v3.guice.internal.JdbiGlobal;

public abstract class AbstractJdbiConfigurationModule
extends AbstractModule
implements JdbiBinder {
    private InternalJdbiBinder jdbiBinder;
    private final Class<? extends Annotation> annotationClass;

    public AbstractJdbiConfigurationModule() {
        this(JdbiGlobal.class);
    }

    public AbstractJdbiConfigurationModule(Class<? extends Annotation> annotationClass) {
        this.annotationClass = (Class)Preconditions.checkNotNull(annotationClass, (Object)"annotationClass is null");
    }

    protected final void configure() {
        this.jdbiBinder = InternalJdbiBinder.jdbiBinder(this.binder(), this.annotationClass);
        try {
            this.install((Module)InternalGlobalJdbiModule.forAnnotation(this.annotationClass));
            this.configureJdbi();
        }
        finally {
            this.jdbiBinder = null;
        }
    }

    public abstract void configureJdbi();

    @Override
    public final JdbiBinder jdbiBinder() {
        Preconditions.checkState((this.jdbiBinder != null ? 1 : 0) != 0, (Object)"The jdbiBinder can only be used inside configureJdbi()");
        return this.jdbiBinder;
    }
}

