/*
 * Decompiled with CFR 0.152.
 */
package org.jdbi.v3.guice.internal;

import com.google.common.base.Preconditions;
import com.google.inject.Inject;
import java.util.Set;
import javax.inject.Provider;
import javax.inject.Singleton;
import javax.sql.DataSource;
import org.jdbi.v3.core.Jdbi;
import org.jdbi.v3.guice.GuiceJdbiCustomizer;
import org.jdbi.v3.guice.internal.JdbiInternal;

@Singleton
public final class InternalGuiceJdbiFactory
implements Provider<Jdbi> {
    private final DataSource dataSource;
    private final Set<GuiceJdbiCustomizer> moduleCustomizers;

    @Inject
    InternalGuiceJdbiFactory(DataSource datasource, @JdbiInternal Set<GuiceJdbiCustomizer> moduleCustomizers) {
        this.dataSource = (DataSource)Preconditions.checkNotNull((Object)datasource, (Object)"datasource is null");
        this.moduleCustomizers = (Set)Preconditions.checkNotNull(moduleCustomizers, (Object)"moduleCustomizers is null");
    }

    public Jdbi get() {
        Jdbi jdbi = Jdbi.create((DataSource)this.dataSource);
        this.moduleCustomizers.forEach(c -> c.customize(jdbi));
        return jdbi;
    }
}

