/*
 * Decompiled with CFR 0.152.
 */
package org.jdbi.v3.guice.internal;

import com.google.inject.Injector;
import com.google.inject.Key;
import com.google.inject.Module;
import com.google.inject.Scopes;
import java.lang.annotation.Annotation;
import javax.inject.Inject;
import javax.inject.Provider;
import org.jdbi.v3.guice.GuiceJdbiCustomizer;

public class InternalOptionalCustomizerProvider
implements Provider<GuiceJdbiCustomizer> {
    private final Class<? extends Annotation> annotation;
    private Injector optionalInjector = null;

    public InternalOptionalCustomizerProvider(Class<? extends Annotation> annotation) {
        this.annotation = annotation;
    }

    public GuiceJdbiCustomizer get() {
        return (GuiceJdbiCustomizer)this.optionalInjector.getInstance(GuiceJdbiCustomizer.class);
    }

    @Inject
    void setInjector(Injector injector) {
        this.optionalInjector = injector.createChildInjector(new Module[]{binder -> {
            Key customizerKey = Key.get(GuiceJdbiCustomizer.class, this.annotation);
            if (injector.getExistingBinding(customizerKey) == null) {
                binder.bind(customizerKey).toInstance(jdbi -> {});
            }
            binder.bind(GuiceJdbiCustomizer.class).to(customizerKey).in(Scopes.SINGLETON);
        }});
    }
}

