/*
 * Decompiled with CFR 0.152.
 */
package org.jdbi.v3.guice.internal;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.inject.Inject;
import com.google.inject.TypeLiteral;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import javax.inject.Singleton;
import org.jdbi.v3.core.Jdbi;
import org.jdbi.v3.core.argument.QualifiedArgumentFactory;
import org.jdbi.v3.core.codec.Codec;
import org.jdbi.v3.core.codec.CodecFactory;
import org.jdbi.v3.core.mapper.ColumnMapper;
import org.jdbi.v3.core.mapper.QualifiedColumnMapperFactory;
import org.jdbi.v3.core.mapper.RowMapper;
import org.jdbi.v3.core.qualifier.QualifiedType;
import org.jdbi.v3.core.spi.JdbiPlugin;
import org.jdbi.v3.guava.codec.TypeResolvingCodecFactory;
import org.jdbi.v3.guice.GuiceJdbiCustomizer;

@Singleton
public class InternalGuiceJdbiCustomizer
implements GuiceJdbiCustomizer {
    static final TypeLiteral<Set<RowMapper<?>>> ROW_MAPPER_TYPE_LITERAL = new TypeLiteral<Set<RowMapper<?>>>(){};
    static final TypeLiteral<Map<Type, RowMapper<?>>> QUALIFIED_ROW_MAPPER_TYPE_LITERAL = new TypeLiteral<Map<Type, RowMapper<?>>>(){};
    static final TypeLiteral<Set<ColumnMapper<?>>> COLUMN_MAPPER_TYPE_LITERAL = new TypeLiteral<Set<ColumnMapper<?>>>(){};
    static final TypeLiteral<Map<QualifiedType<?>, ColumnMapper<?>>> QUALIFIED_COLUMN_MAPPER_TYPE_LITERAL = new TypeLiteral<Map<QualifiedType<?>, ColumnMapper<?>>>(){};
    static final TypeLiteral<Set<GuiceJdbiCustomizer>> CUSTOMIZER_TYPE_LITERAL = new TypeLiteral<Set<GuiceJdbiCustomizer>>(){};
    static final TypeLiteral<Map<Class<?>, String>> ARRAY_TYPES_TYPE_LITERAL = new TypeLiteral<Map<Class<?>, String>>(){};
    static final TypeLiteral<Set<JdbiPlugin>> PLUGINS_TYPE_LITERAL = new TypeLiteral<Set<JdbiPlugin>>(){};
    static final TypeLiteral<Map<QualifiedType<?>, Codec<?>>> CODECS_TYPE_LITERAL = new TypeLiteral<Map<QualifiedType<?>, Codec<?>>>(){};
    private final Set<RowMapper<?>> rowMappers;
    private final Map<Type, RowMapper<?>> qualifiedRowMappers;
    private final Set<ColumnMapper<?>> columnMappers;
    private final Map<QualifiedType<?>, ColumnMapper<?>> qualifiedColumnMappers;
    private final Set<GuiceJdbiCustomizer> customizers;
    private final Map<Class<?>, String> arrayTypes;
    private final Set<JdbiPlugin> plugins;
    private final CodecFactory codecFactory;

    @Inject
    InternalGuiceJdbiCustomizer(Set<RowMapper<?>> rowMappers, Map<Type, RowMapper<?>> qualifiedRowMappers, Set<ColumnMapper<?>> columnMappers, Map<QualifiedType<?>, ColumnMapper<?>> qualifiedColumnMappers, Set<GuiceJdbiCustomizer> customizers, Map<Class<?>, String> arrayTypes, Set<JdbiPlugin> plugins, Map<QualifiedType<?>, Codec<?>> codecs) {
        this.rowMappers = ImmutableSet.copyOf((Collection)((Collection)Preconditions.checkNotNull(rowMappers, (Object)"rowMappers is null")));
        this.qualifiedRowMappers = (Map)Preconditions.checkNotNull(qualifiedRowMappers, (Object)"qualifiedRowMappers is null");
        this.columnMappers = ImmutableSet.copyOf((Collection)((Collection)Preconditions.checkNotNull(columnMappers, (Object)"columnMappers is null")));
        this.qualifiedColumnMappers = (Map)Preconditions.checkNotNull(qualifiedColumnMappers, (Object)"qualifiedColumnMappers is null");
        this.customizers = ImmutableSet.copyOf((Collection)((Collection)Preconditions.checkNotNull(customizers, (Object)"customizers is null")));
        this.arrayTypes = (Map)Preconditions.checkNotNull(arrayTypes, (Object)"arrayTypes is null");
        this.plugins = ImmutableSet.copyOf((Collection)((Collection)Preconditions.checkNotNull(plugins, (Object)"plugins is null")));
        this.codecFactory = new TypeResolvingCodecFactory((Map)Preconditions.checkNotNull(codecs, (Object)"codecs is null"));
    }

    @Override
    public void customize(Jdbi jdbi) {
        this.rowMappers.forEach(arg_0 -> ((Jdbi)jdbi).registerRowMapper(arg_0));
        this.qualifiedRowMappers.forEach((arg_0, arg_1) -> ((Jdbi)jdbi).registerRowMapper(arg_0, arg_1));
        this.columnMappers.forEach(arg_0 -> ((Jdbi)jdbi).registerColumnMapper(arg_0));
        this.qualifiedColumnMappers.forEach((k, v) -> jdbi.registerColumnMapper(k, v));
        jdbi.registerColumnMapper((QualifiedColumnMapperFactory)this.codecFactory);
        jdbi.registerArgument((QualifiedArgumentFactory)this.codecFactory);
        this.plugins.forEach(arg_0 -> ((Jdbi)jdbi).installPlugin(arg_0));
        this.arrayTypes.forEach((arg_0, arg_1) -> ((Jdbi)jdbi).registerArrayType(arg_0, arg_1));
        this.customizers.forEach(c -> c.customize(jdbi));
    }
}

