/*
 * Decompiled with CFR 0.152.
 */
package org.jdbi.v3.guice.internal;

import com.google.common.base.Preconditions;
import com.google.inject.Key;
import com.google.inject.PrivateModule;
import com.google.inject.Scopes;
import java.lang.annotation.Annotation;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import org.jdbi.v3.guice.GuiceJdbiCustomizer;
import org.jdbi.v3.guice.internal.InternalGuiceJdbiCustomizer;

public final class InternalGlobalJdbiModule
extends PrivateModule {
    private static final ConcurrentHashMap<Class<? extends Annotation>, InternalGlobalJdbiModule> REGISTRY = new ConcurrentHashMap();
    private final Class<? extends Annotation> annotation;

    public static InternalGlobalJdbiModule forAnnotation(Class<? extends Annotation> annotation) {
        Preconditions.checkNotNull(annotation, (Object)"annotation is null");
        return REGISTRY.computeIfAbsent(annotation, InternalGlobalJdbiModule::new);
    }

    private InternalGlobalJdbiModule(Class<? extends Annotation> annotation) {
        this.annotation = (Class)Preconditions.checkNotNull(annotation, (Object)"annotation is null");
    }

    public void configure() {
        this.binder().bind(InternalGuiceJdbiCustomizer.ROW_MAPPER_TYPE_LITERAL).to(Key.get(InternalGuiceJdbiCustomizer.ROW_MAPPER_TYPE_LITERAL, this.annotation));
        this.binder().bind(InternalGuiceJdbiCustomizer.QUALIFIED_ROW_MAPPER_TYPE_LITERAL).to(Key.get(InternalGuiceJdbiCustomizer.QUALIFIED_ROW_MAPPER_TYPE_LITERAL, this.annotation));
        this.binder().bind(InternalGuiceJdbiCustomizer.COLUMN_MAPPER_TYPE_LITERAL).to(Key.get(InternalGuiceJdbiCustomizer.COLUMN_MAPPER_TYPE_LITERAL, this.annotation));
        this.binder().bind(InternalGuiceJdbiCustomizer.QUALIFIED_COLUMN_MAPPER_TYPE_LITERAL).to(Key.get(InternalGuiceJdbiCustomizer.QUALIFIED_COLUMN_MAPPER_TYPE_LITERAL, this.annotation));
        this.binder().bind(InternalGuiceJdbiCustomizer.CUSTOMIZER_TYPE_LITERAL).to(Key.get(InternalGuiceJdbiCustomizer.CUSTOMIZER_TYPE_LITERAL, this.annotation));
        this.binder().bind(InternalGuiceJdbiCustomizer.PLUGINS_TYPE_LITERAL).to(Key.get(InternalGuiceJdbiCustomizer.PLUGINS_TYPE_LITERAL, this.annotation));
        this.binder().bind(InternalGuiceJdbiCustomizer.ARRAY_TYPES_TYPE_LITERAL).to(Key.get(InternalGuiceJdbiCustomizer.ARRAY_TYPES_TYPE_LITERAL, this.annotation));
        this.binder().bind(InternalGuiceJdbiCustomizer.CODECS_TYPE_LITERAL).to(Key.get(InternalGuiceJdbiCustomizer.CODECS_TYPE_LITERAL, this.annotation));
        this.binder().bind(GuiceJdbiCustomizer.class).annotatedWith(this.annotation).to(InternalGuiceJdbiCustomizer.class).in(Scopes.SINGLETON);
        this.expose(Key.get(GuiceJdbiCustomizer.class, this.annotation));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        InternalGlobalJdbiModule that = (InternalGlobalJdbiModule)((Object)o);
        return this.annotation.equals(that.annotation);
    }

    public int hashCode() {
        return Objects.hash(this.annotation);
    }
}

