/*
 * Decompiled with CFR 0.152.
 */
package org.jdbi.v3.guice;

import com.google.common.base.Preconditions;
import com.google.inject.Binder;
import com.google.inject.Key;
import com.google.inject.PrivateModule;
import com.google.inject.Scopes;
import com.google.inject.TypeLiteral;
import com.google.inject.multibindings.Multibinder;
import java.lang.annotation.Annotation;
import javax.annotation.Nullable;
import javax.inject.Provider;
import javax.sql.DataSource;
import org.jdbi.v3.core.Jdbi;
import org.jdbi.v3.guice.GuiceJdbiCustomizer;
import org.jdbi.v3.guice.JdbiBinder;
import org.jdbi.v3.guice.internal.InternalGuiceJdbiCustomizer;
import org.jdbi.v3.guice.internal.InternalGuiceJdbiFactory;
import org.jdbi.v3.guice.internal.InternalJdbiBinder;
import org.jdbi.v3.guice.internal.InternalOptionalCustomizerProvider;
import org.jdbi.v3.guice.internal.JdbiGlobal;
import org.jdbi.v3.guice.internal.JdbiInternal;

public abstract class AbstractJdbiDefinitionModule
extends PrivateModule
implements JdbiBinder {
    private final Annotation annotation;
    private final Class<? extends Annotation> annotationClass;
    private final Class<? extends Annotation> globalAnnotationClass;
    private InternalJdbiBinder jdbiBinder;

    public AbstractJdbiDefinitionModule(Annotation annotation) {
        this((Annotation)Preconditions.checkNotNull((Object)annotation, (Object)"annotation is null"), null, JdbiGlobal.class);
    }

    public AbstractJdbiDefinitionModule(Annotation annotation, Class<? extends Annotation> globalAnnotationClass) {
        this((Annotation)Preconditions.checkNotNull((Object)annotation, (Object)"annotation is null"), null, globalAnnotationClass);
    }

    public AbstractJdbiDefinitionModule(Class<? extends Annotation> annotationClass) {
        this(null, (Class)Preconditions.checkNotNull(annotationClass, (Object)"annotationClass is null"), JdbiGlobal.class);
    }

    public AbstractJdbiDefinitionModule(Class<? extends Annotation> annotationClass, Class<? extends Annotation> globalAnnotationClass) {
        this(null, (Class)Preconditions.checkNotNull(annotationClass, (Object)"annotationClass is null"), globalAnnotationClass);
    }

    private AbstractJdbiDefinitionModule(@Nullable Annotation annotation, @Nullable Class<? extends Annotation> annotationClass, @Nullable Class<? extends Annotation> globalAnnotationClass) {
        this.annotation = annotation;
        this.annotationClass = annotationClass;
        this.globalAnnotationClass = globalAnnotationClass;
    }

    protected final void configure() {
        this.jdbiBinder = InternalJdbiBinder.jdbiBinder((Binder)this.binder());
        try {
            Multibinder customizers = Multibinder.newSetBinder((Binder)this.binder(), GuiceJdbiCustomizer.class, JdbiInternal.class);
            if (this.globalAnnotationClass != null) {
                customizers.addBinding().toProvider((Provider)new InternalOptionalCustomizerProvider(this.globalAnnotationClass));
            }
            customizers.addBinding().to(InternalGuiceJdbiCustomizer.class).in(Scopes.SINGLETON);
            this.importBinding(DataSource.class);
            this.bind(Jdbi.class).toProvider(InternalGuiceJdbiFactory.class).in(Scopes.SINGLETON);
            this.exposeBinding(Jdbi.class);
            this.configureJdbi();
        }
        finally {
            this.jdbiBinder = null;
        }
    }

    public abstract void configureJdbi();

    @Override
    public final JdbiBinder jdbiBinder() {
        Preconditions.checkState((this.jdbiBinder != null ? 1 : 0) != 0, (Object)"The jdbiBinder can only be used inside configureJdbi()");
        return this.jdbiBinder;
    }

    public final <T> void importBinding(Class<T> clazz) {
        Preconditions.checkNotNull(clazz, (Object)"clazz is null");
        this.importBinding(TypeLiteral.get(clazz));
    }

    public final <T> void importBinding(TypeLiteral<T> type) {
        Preconditions.checkNotNull(type, (Object)"type is null");
        Key key = null;
        if (this.annotation != null) {
            key = Key.get(type, (Annotation)this.annotation);
        } else if (this.annotationClass != null) {
            key = Key.get(type, this.annotationClass);
        }
        if (key != null) {
            this.bind(type).to(key).in(Scopes.SINGLETON);
        }
    }

    public final <T> void exposeBinding(Class<T> clazz) {
        Preconditions.checkNotNull(clazz, (Object)"clazz is null");
        this.exposeBinding(TypeLiteral.get(clazz));
    }

    public final <T> void exposeBinding(TypeLiteral<T> type) {
        Preconditions.checkNotNull(type, (Object)"type is null");
        if (this.annotation != null) {
            this.bind(type).annotatedWith(this.annotation).to(type).in(Scopes.SINGLETON);
            this.expose(type).annotatedWith(this.annotation);
        } else if (this.annotationClass != null) {
            this.bind(type).annotatedWith(this.annotationClass).to(type).in(Scopes.SINGLETON);
            this.expose(type).annotatedWith(this.annotationClass);
        }
    }
}

