/*
 * Decompiled with CFR 0.152.
 */
package org.jdbi.v3.guava;

import com.google.common.collect.ImmutableList;
import java.lang.reflect.Type;
import java.sql.Array;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Optional;
import org.jdbi.v3.core.config.ConfigRegistry;
import org.jdbi.v3.core.generic.GenericTypes;
import org.jdbi.v3.core.mapper.ColumnMapper;
import org.jdbi.v3.core.mapper.ColumnMapperFactory;
import org.jdbi.v3.core.mapper.ColumnMappers;
import org.jdbi.v3.core.statement.StatementContext;

public class GuavaMappers {
    public static ColumnMapperFactory columnFactory() {
        return new ColumnFactory();
    }

    static class ImmutableListArrayColumnMapper<T>
    implements ColumnMapper<ImmutableList<T>> {
        private final ColumnMapper<T> elementMapper;

        ImmutableListArrayColumnMapper(ColumnMapper<T> elementMapper) {
            this.elementMapper = elementMapper;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public ImmutableList<T> map(ResultSet r, int columnNumber, StatementContext ctx) throws SQLException {
            Array array = r.getArray(columnNumber);
            try {
                ImmutableList<T> immutableList = this.buildFromResultSet(array, ctx);
                return immutableList;
            }
            finally {
                array.free();
            }
        }

        private ImmutableList<T> buildFromResultSet(Array array, StatementContext ctx) throws SQLException {
            ImmutableList.Builder list = ImmutableList.builder();
            try (ResultSet rs = array.getResultSet();){
                while (rs.next()) {
                    list.add(this.elementMapper.map(rs, 2, ctx));
                }
            }
            return list.build();
        }
    }

    static class ColumnFactory
    implements ColumnMapperFactory {
        ColumnFactory() {
        }

        public Optional<ColumnMapper<?>> build(Type type, ConfigRegistry config) {
            Class erasedType = GenericTypes.getErasedType((Type)type);
            if (ImmutableList.class.equals((Object)erasedType)) {
                return GenericTypes.findGenericParameter((Type)type, ImmutableList.class).flatMap(t -> ((ColumnMappers)config.get(ColumnMappers.class)).findFor(t)).map(ImmutableListArrayColumnMapper::new);
            }
            return Optional.empty();
        }
    }
}

