/*
 * Decompiled with CFR 0.152.
 */
package org.jdbi.v3.guava;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSortedSet;
import java.lang.reflect.Type;
import java.util.Comparator;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collector;
import org.jdbi.v3.core.collector.CollectorFactory;
import org.jdbi.v3.core.generic.GenericTypes;

public class GuavaCollectors {
    public static CollectorFactory factory() {
        return new Factory();
    }

    public static <T> Collector<T, ?, com.google.common.base.Optional<T>> toOptional() {
        return Collector.of(() -> new GuavaOptionalBuilder(), GuavaOptionalBuilder::set, (left, right) -> left.build().isPresent() ? left : right, GuavaOptionalBuilder::build, new Collector.Characteristics[0]);
    }

    public static class Factory
    implements CollectorFactory {
        private static final Map<Class<?>, Collector<?, ?, ?>> collectors = ImmutableMap.builder().put(ImmutableList.class, (Object)ImmutableList.toImmutableList()).put(ImmutableSet.class, (Object)ImmutableSet.toImmutableSet()).put(ImmutableSortedSet.class, (Object)ImmutableSortedSet.toImmutableSortedSet(Comparator.naturalOrder())).put(com.google.common.base.Optional.class, GuavaCollectors.toOptional()).build();

        public boolean accepts(Type containerType) {
            return collectors.containsKey(GenericTypes.getErasedType((Type)containerType));
        }

        public Optional<Type> elementType(Type containerType) {
            return GenericTypes.findGenericParameter((Type)containerType, (Class)GenericTypes.getErasedType((Type)containerType));
        }

        public Collector<?, ?, ?> build(Type containerType) {
            return collectors.get(GenericTypes.getErasedType((Type)containerType));
        }
    }

    private static class GuavaOptionalBuilder<T> {
        private com.google.common.base.Optional<T> optional = com.google.common.base.Optional.absent();

        private GuavaOptionalBuilder() {
        }

        public void set(T value) {
            if (this.optional.isPresent()) {
                throw new IllegalStateException(String.format("Multiple values for Optional type: ['%s','%s',...]", this.optional.get(), value));
            }
            this.optional = com.google.common.base.Optional.of(value);
        }

        public com.google.common.base.Optional<T> build() {
            return this.optional;
        }
    }
}

