/*
 * Decompiled with CFR 0.152.
 */
package org.jdbi.v3.generator;

import com.squareup.javapoet.CodeBlock;
import com.squareup.javapoet.FieldSpec;
import com.squareup.javapoet.JavaFile;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import java.io.IOException;
import java.io.Writer;
import java.lang.reflect.Method;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.Filer;
import javax.annotation.processing.Messager;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.Name;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;
import javax.tools.Diagnostic;
import javax.tools.JavaFileObject;
import org.jdbi.v3.core.Jdbi;
import org.jdbi.v3.core.config.ConfigRegistry;
import org.jdbi.v3.core.extension.ExtensionMetadata;
import org.jdbi.v3.core.extension.HandleSupplier;
import org.jdbi.v3.core.internal.JdbiClassUtils;
import org.jdbi.v3.sqlobject.SqlObject;

@SupportedAnnotationTypes(value={"org.jdbi.v3.sqlobject.GenerateSqlObject"})
public class GenerateSqlObjectProcessor
extends AbstractProcessor {
    public static final String GENERATE_SQL_OBJECT_ANNOTATION_NAME = "org.jdbi.v3.sqlobject.GenerateSqlObject";
    private static final Set<ElementKind> ACCEPTABLE_ELEMENT_TYPES = EnumSet.of(ElementKind.CLASS, ElementKind.INTERFACE);
    private Elements elementUtils;
    private Types typeUtils;
    private Filer filer;
    private Messager messager;

    @Override
    public SourceVersion getSupportedSourceVersion() {
        return SourceVersion.latestSupported();
    }

    @Override
    public synchronized void init(ProcessingEnvironment processingEnv) {
        super.init(processingEnv);
        this.elementUtils = processingEnv.getElementUtils();
        this.typeUtils = processingEnv.getTypeUtils();
        this.filer = processingEnv.getFiler();
        this.messager = processingEnv.getMessager();
    }

    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        TypeElement generateSqlAnnotation = this.elementUtils.getTypeElement(GENERATE_SQL_OBJECT_ANNOTATION_NAME);
        Set<? extends Element> annotatedElements = roundEnv.getElementsAnnotatedWith(generateSqlAnnotation);
        for (Element element : annotatedElements) {
            if (!ACCEPTABLE_ELEMENT_TYPES.contains((Object)element.getKind())) {
                throw new IllegalStateException("@GenerateSqlObject annotation on unsupported element: " + element);
            }
            if (!element.getModifiers().contains((Object)Modifier.ABSTRACT)) {
                throw new IllegalStateException("@GenerateSqlObject on a non-abstract class: " + element);
            }
            this.generateSourceFile(element);
        }
        return false;
    }

    private void generateSourceFile(Element element) {
        this.messager.printMessage(Diagnostic.Kind.NOTE, String.format("[jdbi] generating for %s", element));
        try {
            SqlObjectFile sqlObjectFile = new SqlObjectFile((TypeElement)element);
            sqlObjectFile.addMethod(this.forMethod(SqlObject.class, "getHandle"));
            sqlObjectFile.addMethod(this.forMethod(SqlObject.class, "withHandle"));
            sqlObjectFile.writeFile();
        }
        catch (RuntimeException e) {
            this.messager.printMessage(Diagnostic.Kind.ERROR, String.format("@GenerateSqlObject processor threw an exception for '%s': %s", element, e));
            throw e;
        }
    }

    private ExecutableElement forMethod(Class<?> klass, String name) {
        return this.elementUtils.getTypeElement(klass.getName()).getEnclosedElements().stream().filter(e -> e.getSimpleName().toString().equals(name)).findFirst().map(ExecutableElement.class::cast).orElseThrow(() -> new IllegalStateException(String.format("no %s.%s found!", klass, name)));
    }

    private static String getImplementationClassName(TypeElement typeElement) {
        return typeElement.getSimpleName() + "Impl";
    }

    private final class SqlObjectFile {
        private final TypeElement typeElement;
        private final TypeName typeName;
        private final TypeSpec.Builder implementationBuilder;
        private final TypeSpec.Builder onDemandBuilder;
        private final CodeBlock.Builder implementationCtorBuilder = CodeBlock.builder();
        private long counter = 0L;

        private SqlObjectFile(TypeElement typeElement) {
            this.typeElement = typeElement;
            this.typeName = TypeName.get((TypeMirror)typeElement.asType());
            this.implementationBuilder = TypeSpec.classBuilder((String)GenerateSqlObjectProcessor.getImplementationClassName(typeElement)).addModifiers(new Modifier[]{Modifier.PUBLIC});
            this.addSupertypes(this.implementationBuilder);
            this.onDemandBuilder = TypeSpec.classBuilder((String)"OnDemand").addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.STATIC});
            this.addSupertypes(this.onDemandBuilder);
            this.onDemandBuilder.addField(Jdbi.class, "jdbi", new Modifier[]{Modifier.PRIVATE, Modifier.FINAL});
            this.onDemandBuilder.addMethod(MethodSpec.constructorBuilder().addModifiers(new Modifier[]{Modifier.PUBLIC}).addParameter(Jdbi.class, "jdbi", new Modifier[0]).addCode("this.jdbi = jdbi;\n", new Object[0]).build());
            this.getMethods().forEach(this::addMethod);
        }

        private void addMethod(ExecutableElement method) {
            this.addImplementationMethod(method);
            this.addOnDemandMethod(method);
        }

        private List<ExecutableElement> getMethods() {
            return this.typeElement.getEnclosedElements().stream().filter(element -> element.getKind() == ElementKind.METHOD).map(ExecutableElement.class::cast).filter(element -> !element.getModifiers().contains((Object)Modifier.PRIVATE)).collect(Collectors.toList());
        }

        private void addSupertypes(TypeSpec.Builder builder) {
            if (this.typeElement.getKind() == ElementKind.CLASS) {
                builder.superclass(this.typeName);
            } else {
                builder.addSuperinterface(this.typeName);
            }
            builder.addSuperinterface(SqlObject.class);
        }

        private void addImplementationMethod(ExecutableElement method) {
            String paramTypes = method.getParameters().stream().map(Element::asType).map(GenerateSqlObjectProcessor.this.typeUtils::erasure).map(t -> t + ".class").collect(Collectors.joining(","));
            Name methodName = method.getSimpleName();
            String methodField = "m_" + methodName + "_" + this.counter;
            String invokerField = "i_" + methodName + "_" + this.counter++;
            this.implementationBuilder.addField(FieldSpec.builder(Method.class, (String)methodField, (Modifier[])new Modifier[]{Modifier.PRIVATE, Modifier.STATIC, Modifier.FINAL}).initializer("$T.methodLookup($T.class, $S$L$L)", new Object[]{JdbiClassUtils.class, method.getEnclosingElement().asType(), methodName, paramTypes.isEmpty() ? "" : ", ", paramTypes}).build());
            this.implementationBuilder.addField(ExtensionMetadata.ExtensionHandlerInvoker.class, invokerField, new Modifier[]{Modifier.PRIVATE, Modifier.FINAL});
            this.implementationCtorBuilder.add("$L = extensionMetadata.createExtensionHandlerInvoker(this, $L, handleSupplier, config);\n", new Object[]{invokerField, methodField});
            CodeBlock.Builder body = CodeBlock.builder();
            String castReturn = method.getReturnType().getKind() == TypeKind.VOID ? "" : String.format("return (%s)", method.getReturnType());
            String paramList = this.paramList(method);
            if (method.getModifiers().contains((Object)Modifier.ABSTRACT)) {
                body.add("$L $L.invoke($L);\n", new Object[]{castReturn, invokerField, paramList});
            } else {
                body.add("$L $L.call(() -> ", new Object[]{castReturn, invokerField});
                if (method.getModifiers().contains((Object)Modifier.DEFAULT)) {
                    body.add("$T.", new Object[]{method.getEnclosingElement().asType()});
                }
                body.add("super.$L($L));\n", new Object[]{methodName, paramList});
            }
            this.implementationBuilder.addMethod(MethodSpec.overriding((ExecutableElement)method).addCode(body.build()).build());
        }

        private void addOnDemandMethod(ExecutableElement method) {
            String castReturn;
            String jdbiMethod;
            if (method.getReturnType().getKind() == TypeKind.VOID) {
                jdbiMethod = "useExtension";
                castReturn = "";
            } else {
                jdbiMethod = "withExtension";
                castReturn = String.format("return (%s)", method.getReturnType());
            }
            this.onDemandBuilder.addMethod(MethodSpec.overriding((ExecutableElement)method).addCode(CodeBlock.builder().add("$L jdbi.$L($T.class, e -> (($L) e).$L($L));\n", new Object[]{castReturn, jdbiMethod, this.typeElement.asType(), GenerateSqlObjectProcessor.getImplementationClassName(this.typeElement), method.getSimpleName(), this.paramList(method)}).build()).build());
        }

        private String paramList(ExecutableElement method) {
            return method.getParameters().stream().map(VariableElement::getSimpleName).map(Object::toString).collect(Collectors.joining(","));
        }

        private void writeFile() {
            this.implementationBuilder.addType(this.onDemandBuilder.build());
            this.implementationBuilder.addMethod(MethodSpec.constructorBuilder().addModifiers(new Modifier[]{Modifier.PUBLIC}).addParameter(ExtensionMetadata.class, "extensionMetadata", new Modifier[0]).addParameter(HandleSupplier.class, "handleSupplier", new Modifier[0]).addParameter(ConfigRegistry.class, "config", new Modifier[0]).addCode(this.implementationCtorBuilder.build()).build());
            try {
                PackageElement typePackage = GenerateSqlObjectProcessor.this.elementUtils.getPackageOf(this.typeElement);
                JavaFileObject file = GenerateSqlObjectProcessor.this.filer.createSourceFile(String.format("%s.%s", typePackage, GenerateSqlObjectProcessor.getImplementationClassName(this.typeElement)), this.typeElement);
                try (Writer out = file.openWriter();){
                    JavaFile.builder((String)typePackage.toString(), (TypeSpec)this.implementationBuilder.build()).build().writeTo((Appendable)out);
                }
            }
            catch (IOException e) {
                GenerateSqlObjectProcessor.this.messager.printMessage(Diagnostic.Kind.WARNING, String.format("Could not write generated class %s: %s", this.typeElement, e));
            }
        }
    }
}

