/*
 * Decompiled with CFR 0.152.
 */
package org.jdbi.v3.generator;

import com.squareup.javapoet.CodeBlock;
import com.squareup.javapoet.JavaFile;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import java.io.IOException;
import java.io.Writer;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.annotation.processing.SupportedSourceVersion;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.Types;
import javax.tools.Diagnostic;
import javax.tools.JavaFileObject;
import org.jdbi.v3.core.Jdbi;
import org.jdbi.v3.core.config.ConfigRegistry;
import org.jdbi.v3.core.extension.HandleSupplier;
import org.jdbi.v3.core.generic.GenericType;
import org.jdbi.v3.sqlobject.SqlObject;
import org.jdbi.v3.sqlobject.internal.SqlObjectInitData;

@SupportedAnnotationTypes(value={"org.jdbi.v3.sqlobject.GenerateSqlObject"})
@SupportedSourceVersion(value=SourceVersion.RELEASE_8)
public class GenerateSqlObjectProcessor
extends AbstractProcessor {
    private static final Set<ElementKind> ACCEPTABLE = EnumSet.of(ElementKind.CLASS, ElementKind.INTERFACE);
    private long counter = 0L;

    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        if (annotations.isEmpty()) {
            return false;
        }
        TypeElement gens = annotations.iterator().next();
        Set<? extends Element> annoTypes = roundEnv.getElementsAnnotatedWith(gens);
        annoTypes.forEach(this::tryGenerate);
        return true;
    }

    private void tryGenerate(Element sqlObj) {
        try {
            this.generate(sqlObj);
        }
        catch (Exception ex) {
            this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, "Failure: " + ex, sqlObj);
            throw new RuntimeException(ex);
        }
    }

    private void generate(Element sqlObjE) throws IOException {
        this.processingEnv.getMessager().printMessage(Diagnostic.Kind.NOTE, String.format("[jdbi] generating for %s", sqlObjE));
        if (!ACCEPTABLE.contains((Object)sqlObjE.getKind())) {
            throw new IllegalStateException("Generate on non-class: " + sqlObjE);
        }
        if (!sqlObjE.getModifiers().contains((Object)Modifier.ABSTRACT)) {
            throw new IllegalStateException("Generate on non-abstract class: " + sqlObjE);
        }
        TypeElement sqlObj = (TypeElement)sqlObjE;
        String implName = sqlObj.getSimpleName() + "Impl";
        TypeSpec.Builder implSpec = TypeSpec.classBuilder((String)implName).addModifiers(new Modifier[]{Modifier.PUBLIC});
        TypeName superName = TypeName.get((TypeMirror)sqlObj.asType());
        this.addSuper(implSpec, sqlObj, superName);
        implSpec.addSuperinterface(SqlObject.class);
        CodeBlock.Builder staticInit = CodeBlock.builder().add("initData = $T.initData();\n", new Object[]{SqlObjectInitData.class});
        CodeBlock.Builder constructor = CodeBlock.builder();
        implSpec.addField(SqlObjectInitData.class, "initData", new Modifier[]{Modifier.PRIVATE, Modifier.STATIC, Modifier.FINAL});
        List implMethods = sqlObj.getEnclosedElements().stream().filter(ee -> ee.getKind() == ElementKind.METHOD).map(ExecutableElement.class::cast).filter(ee -> !ee.getModifiers().contains((Object)Modifier.PRIVATE)).collect(Collectors.toCollection(ArrayList::new));
        implMethods.add(this.element(SqlObject.class, "getHandle"));
        implMethods.add(this.element(SqlObject.class, "withHandle"));
        implMethods.stream().map(ee -> this.generateMethod(implSpec, staticInit, constructor, (Element)ee)).forEach(arg_0 -> ((TypeSpec.Builder)implSpec).addMethod(arg_0));
        TypeSpec.Builder onDemand = TypeSpec.classBuilder((String)"OnDemand");
        onDemand.addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.STATIC});
        onDemand.addField(Jdbi.class, "db", new Modifier[]{Modifier.PRIVATE, Modifier.FINAL});
        onDemand.addMethod(MethodSpec.constructorBuilder().addModifiers(new Modifier[]{Modifier.PUBLIC}).addParameter(Jdbi.class, "db", new Modifier[0]).addCode("this.db = db;\n", new Object[0]).build());
        this.addSuper(onDemand, sqlObj, superName);
        implMethods.stream().map(method -> this.generateOnDemand(sqlObj, (ExecutableElement)method)).forEach(arg_0 -> ((TypeSpec.Builder)onDemand).addMethod(arg_0));
        implSpec.addType(onDemand.build());
        implSpec.addMethod(MethodSpec.constructorBuilder().addModifiers(new Modifier[]{Modifier.PUBLIC}).addParameter(HandleSupplier.class, "handle", new Modifier[0]).addParameter(ConfigRegistry.class, "config", new Modifier[0]).addCode(constructor.build()).build());
        implSpec.addStaticBlock(staticInit.build());
        JavaFileObject file = this.processingEnv.getFiler().createSourceFile(this.processingEnv.getElementUtils().getPackageOf(sqlObjE) + "." + implName, sqlObjE);
        try (Writer out = file.openWriter();){
            JavaFile.builder((String)this.packageName(sqlObj), (TypeSpec)implSpec.build()).build().writeTo((Appendable)out);
        }
    }

    private MethodSpec generateMethod(TypeSpec.Builder typeBuilder, CodeBlock.Builder staticInit, CodeBlock.Builder init, Element el) {
        CodeBlock.Builder body;
        String castReturn;
        Types typeUtils = this.processingEnv.getTypeUtils();
        ExecutableElement method = (ExecutableElement)el;
        String paramList = this.paramList(method);
        String paramTypes = method.getParameters().stream().map(Element::asType).map(typeUtils::erasure).map(t -> t + ".class").collect(Collectors.joining(","));
        String methodField = "m_" + el.getSimpleName() + "_" + this.counter;
        String invokerField = "i_" + el.getSimpleName() + "_" + this.counter++;
        typeBuilder.addField(Method.class, methodField, new Modifier[]{Modifier.PRIVATE, Modifier.STATIC, Modifier.FINAL});
        typeBuilder.addField(new GenericType<Supplier<SqlObjectInitData.InContextInvoker>>(){}.getType(), invokerField, new Modifier[]{Modifier.PRIVATE, Modifier.FINAL});
        staticInit.add("$L = initData.lookupMethod($S, new Class<?>[] {$L});\n", new Object[]{methodField, el.getSimpleName(), paramTypes});
        init.add("$L = initData.lazyInvoker(this, $L, handle, config);\n", new Object[]{invokerField, methodField});
        String string = castReturn = method.getReturnType().getKind() == TypeKind.VOID ? "" : "return (" + method.getReturnType().toString() + ")";
        if (method.getModifiers().contains((Object)Modifier.ABSTRACT)) {
            body = CodeBlock.builder().add("$L $L.get().invoke(new Object[] {$L});\n", new Object[]{castReturn, invokerField, paramList});
        } else {
            body = CodeBlock.builder().add("$L $L.get().call(() -> ", new Object[]{castReturn, invokerField});
            if (el.getModifiers().contains((Object)Modifier.DEFAULT)) {
                body.add("$T.", new Object[]{method.getEnclosingElement().asType()});
            }
            body.add("super.$L($L));\n", new Object[]{el.getSimpleName(), paramList});
        }
        return MethodSpec.overriding((ExecutableElement)method).addCode(body.build()).build();
    }

    private MethodSpec generateOnDemand(TypeElement sqlObjectType, ExecutableElement method) {
        return MethodSpec.overriding((ExecutableElement)method).addCode(CodeBlock.builder().add("$L db.$L($T.class, e -> e.$L($L));\n", new Object[]{method.getReturnType().getKind() == TypeKind.VOID ? "" : "return (" + method.getReturnType().toString() + ")", method.getReturnType().getKind() == TypeKind.VOID ? "useExtension" : "withExtension", sqlObjectType.asType(), method.getSimpleName(), this.paramList(method)}).build()).build();
    }

    private ExecutableElement element(Class<?> klass, String name) {
        return this.processingEnv.getElementUtils().getTypeElement(klass.getName()).getEnclosedElements().stream().filter(e -> e.getSimpleName().toString().equals(name)).findFirst().map(ExecutableElement.class::cast).orElseThrow(() -> new IllegalStateException("no " + klass + "." + name + " found"));
    }

    private String paramList(ExecutableElement method) {
        return method.getParameters().stream().map(VariableElement::getSimpleName).map(Object::toString).collect(Collectors.joining(","));
    }

    private String packageName(Element e) {
        return this.processingEnv.getElementUtils().getPackageOf(e).toString();
    }

    private void addSuper(TypeSpec.Builder spec, TypeElement el, TypeName superName) {
        if (el.getKind() == ElementKind.CLASS) {
            spec.superclass(superName);
        } else {
            spec.addSuperinterface(superName);
        }
    }
}

