/*
 * Decompiled with CFR 0.152.
 */
package org.jdbi.v3.freemarker.internal;

import freemarker.template.Template;
import freemarker.template.TemplateException;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import org.jdbi.v3.core.config.ConfigRegistry;
import org.jdbi.v3.core.statement.SqlStatements;
import org.jdbi.v3.core.statement.TemplateEngine;
import org.jdbi.v3.freemarker.FreemarkerSqlLocator;
import org.jdbi.v3.sqlobject.SqlObjects;
import org.jdbi.v3.sqlobject.config.Configurer;
import org.jdbi.v3.sqlobject.internal.SqlAnnotations;
import org.jdbi.v3.sqlobject.locator.SqlLocator;

public class UseFreemarkerSqlLocatorImpl
implements Configurer {
    public void configureForType(ConfigRegistry registry, Annotation annotation, Class<?> sqlObjectType) {
        SqlLocator locator = (type, method, config) -> {
            String templateName = SqlAnnotations.getAnnotationValue((Method)method).orElseGet(method::getName);
            FreemarkerSqlLocator.findTemplate(sqlObjectType, templateName);
            return templateName;
        };
        TemplateEngine templateEngine = (templateName, ctx) -> {
            Template template = FreemarkerSqlLocator.findTemplate(sqlObjectType, templateName);
            StringWriter writer = new StringWriter();
            try {
                template.process((Object)ctx.getAttributes(), (Writer)writer);
                return writer.toString();
            }
            catch (TemplateException | IOException e) {
                throw new IllegalStateException("Failed to render template " + templateName, e);
            }
        };
        ((SqlObjects)registry.get(SqlObjects.class)).setSqlLocator(locator);
        ((SqlStatements)registry.get(SqlStatements.class)).setTemplateEngine(templateEngine);
    }

    public void configureForMethod(ConfigRegistry registry, Annotation annotation, Class<?> sqlObjectType, Method method) {
        this.configureForType(registry, annotation, sqlObjectType);
    }
}

