/*
 * Decompiled with CFR 0.152.
 */
package org.jdbi.v3.freemarker;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import freemarker.template.Template;
import freemarker.template.TemplateException;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Optional;
import java.util.function.Function;
import org.jdbi.v3.core.config.ConfigRegistry;
import org.jdbi.v3.core.statement.StatementContext;
import org.jdbi.v3.core.statement.TemplateEngine;
import org.jdbi.v3.freemarker.FreemarkerConfig;

public class FreemarkerEngine
implements TemplateEngine.Parsing {
    private static final FreemarkerEngine INSTANCE = new FreemarkerEngine();

    @Deprecated(since="3.39.0", forRemoval=true)
    @SuppressFBWarnings(value={"SING_SINGLETON_HAS_NONPRIVATE_CONSTRUCTOR"})
    public FreemarkerEngine() {
    }

    public static FreemarkerEngine instance() {
        return INSTANCE;
    }

    public Optional<Function<StatementContext, String>> parse(String sqlTemplate, ConfigRegistry config) {
        try {
            Template template = new Template(null, sqlTemplate, ((FreemarkerConfig)config.get(FreemarkerConfig.class)).getFreemarkerConfiguration());
            return Optional.of(ctx -> {
                try {
                    StringWriter writer = new StringWriter();
                    template.process((Object)ctx.getAttributes(), (Writer)writer);
                    return writer.toString();
                }
                catch (TemplateException | IOException e) {
                    throw new IllegalStateException("Failed to render template: " + sqlTemplate, e);
                }
            });
        }
        catch (IOException e) {
            throw new IllegalStateException("Failed to process template: " + sqlTemplate, e);
        }
    }
}

