/*
 * Decompiled with CFR 0.152.
 */
package org.jdbi.v3.freemarker.internal;

import freemarker.template.Template;
import freemarker.template.TemplateException;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import org.jdbi.v3.core.config.ConfigRegistry;
import org.jdbi.v3.core.extension.SimpleExtensionConfigurer;
import org.jdbi.v3.core.statement.SqlStatements;
import org.jdbi.v3.core.statement.TemplateEngine;
import org.jdbi.v3.freemarker.FreemarkerConfig;
import org.jdbi.v3.freemarker.FreemarkerSqlLocator;
import org.jdbi.v3.sqlobject.SqlObjects;
import org.jdbi.v3.sqlobject.internal.SqlAnnotations;
import org.jdbi.v3.sqlobject.locator.SqlLocator;

public class UseFreemarkerSqlLocatorImpl
extends SimpleExtensionConfigurer {
    public void configure(ConfigRegistry config, Annotation annotation, Class<?> sqlObjectType) {
        SqlLocator locator = (type, method, c) -> SqlAnnotations.getAnnotationValue((Method)method).orElseGet(method::getName);
        TemplateEngine templateEngine = (templateName, ctx) -> {
            Template template = FreemarkerSqlLocator.findTemplate(((FreemarkerConfig)ctx.getConfig(FreemarkerConfig.class)).getFreemarkerConfiguration(), sqlObjectType, templateName);
            StringWriter writer = new StringWriter();
            try {
                template.process((Object)ctx.getAttributes(), (Writer)writer);
                return writer.toString();
            }
            catch (TemplateException | IOException e) {
                throw new IllegalStateException("Failed to render template " + templateName, e);
            }
        };
        ((SqlObjects)config.get(SqlObjects.class)).setSqlLocator(locator);
        ((SqlStatements)config.get(SqlStatements.class)).setTemplateEngine(templateEngine);
    }
}

