/*
 * Decompiled with CFR 0.152.
 */
package org.jdbi.v3.freemarker;

import freemarker.cache.ClassTemplateLoader;
import freemarker.cache.TemplateLoader;
import freemarker.template.Configuration;
import java.util.Optional;
import org.jdbi.v3.core.config.JdbiConfig;
import org.jdbi.v3.freemarker.FreemarkerSqlLocator;

public class FreemarkerConfig
implements JdbiConfig<FreemarkerConfig> {
    private Configuration freemarkerConfiguration;

    public FreemarkerConfig() {
        this.freemarkerConfiguration = new Configuration(Configuration.DEFAULT_INCOMPATIBLE_IMPROVEMENTS);
        this.freemarkerConfiguration.setTemplateLoader((TemplateLoader)new ClassTemplateLoader(FreemarkerConfig.selectClassLoader(), "/"));
        this.freemarkerConfiguration.setNumberFormat("computer");
    }

    private FreemarkerConfig(FreemarkerConfig other) {
        this.freemarkerConfiguration = other.freemarkerConfiguration;
    }

    public FreemarkerConfig setFreemarkerConfiguration(Configuration freemarkerConfiguration) {
        this.freemarkerConfiguration = freemarkerConfiguration;
        return this;
    }

    public Configuration getFreemarkerConfiguration() {
        return this.freemarkerConfiguration;
    }

    public FreemarkerSqlLocator createLocator() {
        return new FreemarkerSqlLocator(this);
    }

    public FreemarkerConfig createCopy() {
        return new FreemarkerConfig(this);
    }

    private static ClassLoader selectClassLoader() {
        return Optional.ofNullable(Thread.currentThread().getContextClassLoader()).orElseGet(FreemarkerConfig.class::getClassLoader);
    }
}

