/*
 * Decompiled with CFR 0.152.
 */
package org.jdbi.v3.freemarker;

import freemarker.cache.ClassTemplateLoader;
import freemarker.cache.TemplateLoader;
import freemarker.template.Configuration;
import freemarker.template.Template;
import java.util.Optional;

public class FreemarkerSqlLocator {
    private static final Configuration CONFIGURATION;

    private FreemarkerSqlLocator() {
    }

    private static ClassLoader selectClassLoader() {
        return Optional.ofNullable(Thread.currentThread().getContextClassLoader()).orElseGet(FreemarkerSqlLocator.class::getClassLoader);
    }

    public static Template findTemplate(Class<?> type, String templateName) {
        String path = type.getName().replace(".", "/") + "/" + templateName + ".sql.ftl";
        try {
            return CONFIGURATION.getTemplate(path);
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to load Freemarker template " + templateName + " in " + path, e);
        }
    }

    static {
        Configuration c = new Configuration(Configuration.DEFAULT_INCOMPATIBLE_IMPROVEMENTS);
        c.setTemplateLoader((TemplateLoader)new ClassTemplateLoader(FreemarkerSqlLocator.selectClassLoader(), "/"));
        CONFIGURATION = c;
    }
}

