/*
 * Decompiled with CFR 0.152.
 */
package org.jdbi.v3.freemarker;

import freemarker.template.Template;
import freemarker.template.TemplateException;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.function.Function;
import org.jdbi.v3.core.config.ConfigRegistry;
import org.jdbi.v3.core.config.JdbiCache;
import org.jdbi.v3.core.config.JdbiCaches;
import org.jdbi.v3.core.statement.StatementContext;
import org.jdbi.v3.core.statement.TemplateEngine;
import org.jdbi.v3.freemarker.FreemarkerConfig;

public class FreemarkerEngine
implements TemplateEngine {
    private static final JdbiCache<String, Function<StatementContext, String>> RENDER_CACHE = JdbiCaches.declare(FreemarkerEngine::prepare);

    public String render(String sql, StatementContext ctx) {
        return (String)((Function)RENDER_CACHE.get((Object)sql, ctx)).apply(ctx);
    }

    private static Function<StatementContext, String> prepare(ConfigRegistry config, String sql) {
        try {
            Template template = new Template(null, sql, ((FreemarkerConfig)config.get(FreemarkerConfig.class)).getFreemarkerConfiguration());
            return ctx -> {
                try {
                    StringWriter writer = new StringWriter();
                    template.process((Object)ctx.getAttributes(), (Writer)writer);
                    return writer.toString();
                }
                catch (TemplateException | IOException e) {
                    throw new IllegalStateException("Failed to render template: " + sql, e);
                }
            };
        }
        catch (IOException e) {
            throw new IllegalStateException("Failed to process template: " + sql, e);
        }
    }
}

