/*
 * Decompiled with CFR 0.152.
 */
package org.jdbi.v3.examples.auth;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.Method;
import java.util.Optional;
import org.jdbi.v3.core.extension.AttachedExtensionHandler;
import org.jdbi.v3.core.extension.ExtensionHandler;
import org.jdbi.v3.core.extension.ExtensionHandlerCustomizer;
import org.jdbi.v3.core.extension.annotation.UseExtensionHandlerCustomizer;
import org.jdbi.v3.core.statement.Query;

public class AuthenticationExample {

    public static class AuthenticationHandler
    implements ExtensionHandlerCustomizer {
        public ExtensionHandler customize(ExtensionHandler handler, Class<?> extensionType, Method method) {
            return (config, target) -> {
                AttachedExtensionHandler delegate = handler.attachTo(config, target);
                return (handleSupplier, args) -> {
                    if (args == null || args.length == 0 || !(args[0] instanceof AuthContext)) {
                        throw new IllegalArgumentException("First argument must be an AuthContext");
                    }
                    AuthContext authContext = (AuthContext)args[0];
                    try (Query query = handleSupplier.getHandle().createQuery("SELECT 1 FROM users WHERE name = :username AND password = :password");){
                        Optional valid = ((Query)((Query)query.bind("username", authContext.getUsername())).bind("password", authContext.getPassword())).mapTo(Integer.class).findOne();
                        if (valid.isEmpty()) {
                            throw new IllegalStateException("Invalid credentials");
                        }
                    }
                    return delegate.invoke(handleSupplier, args);
                };
            };
        }
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.METHOD, ElementType.TYPE})
    @UseExtensionHandlerCustomizer(value=AuthenticationHandler.class)
    public static @interface UseAuthentication {
    }

    public static class AuthContext {
        private final String username;
        private final String password;

        public AuthContext(String username, String password) {
            this.username = username;
            this.password = password;
        }

        public String getUsername() {
            return this.username;
        }

        public String getPassword() {
            return this.password;
        }
    }
}

