/*
 * Decompiled with CFR 0.152.
 */
package org.jdbi.v3.examples.order;

import java.security.SecureRandom;
import java.util.UUID;
import java.util.function.Consumer;
import org.jdbi.v3.core.Jdbi;
import org.jdbi.v3.core.mapper.RowMapper;
import org.jdbi.v3.core.statement.Update;
import org.jdbi.v3.examples.order.OrderMapper;
import org.jdbi.v3.examples.support.DatabaseSupport;

public final class OrderSupport {
    private static final SecureRandom RANDOM = new SecureRandom();

    private OrderSupport() {
        throw new AssertionError((Object)"OrderSupport can not be instantiated");
    }

    public static void withOrders(Consumer<Jdbi> jdbiConsumer) throws Exception {
        DatabaseSupport.withDatabase(jdbi -> {
            OrderSupport.createTables(jdbi);
            OrderSupport.populateOrders(jdbi, 3, 20);
            jdbi.registerRowMapper((RowMapper)new OrderMapper());
            jdbiConsumer.accept((Jdbi)jdbi);
        });
    }

    public static void createTables(Jdbi jdbi) {
        jdbi.withHandle(handle -> handle.execute("CREATE TABLE orders (id INT, user_id INT, comment VARCHAR, address VARCHAR)", new Object[0]));
    }

    public static void populateOrders(Jdbi jdbi, int orderCount, int userIdCount) {
        jdbi.withHandle(handle -> {
            for (int j = 0; j < userIdCount; ++j) {
                int userId = RANDOM.nextInt(10000);
                for (int i = 0; i < orderCount; ++i) {
                    ((Update)((Update)((Update)((Update)handle.createUpdate("INSERT INTO orders (id, user_id, comment, address) VALUES (:id, :user_id, :comment, :address)").bind("id", RANDOM.nextInt(1000000))).bind("user_id", userId)).bind("comment", UUID.randomUUID().toString().substring(0, 5))).bind("address", UUID.randomUUID().toString().substring(0, 5))).execute();
                }
            }
            return null;
        });
    }
}

