/*
 * Decompiled with CFR 0.152.
 */
package org.jdbi.v3.examples.support;

import de.softwareforge.testing.postgres.embedded.DatabaseInfo;
import de.softwareforge.testing.postgres.embedded.DatabaseManager;
import de.softwareforge.testing.postgres.embedded.EmbeddedPostgres;
import java.util.function.Consumer;
import javax.sql.DataSource;
import org.jdbi.v3.core.Jdbi;
import org.jdbi.v3.core.spi.JdbiPlugin;
import org.jdbi.v3.postgres.PostgresPlugin;
import org.jdbi.v3.sqlobject.SqlObjectPlugin;

public final class DatabaseSupport {
    private DatabaseSupport() {
        throw new AssertionError((Object)"DatabaseSupport can not be instantiated");
    }

    public static void withDatabase(Consumer<Jdbi> jdbiConsumer) throws Exception {
        try (DatabaseManager manager = ((DatabaseManager)DatabaseManager.singleDatabase().withInstancePreparer(EmbeddedPostgres.Builder::withDefaults).build()).start();){
            DatabaseInfo databaseInfo = manager.getDatabaseInfo();
            Jdbi jdbi = Jdbi.create((DataSource)databaseInfo.asDataSource());
            jdbi.installPlugin((JdbiPlugin)new SqlObjectPlugin()).installPlugin((JdbiPlugin)new PostgresPlugin());
            jdbiConsumer.accept(jdbi);
        }
    }
}

