/*
 * Decompiled with CFR 0.152.
 */
package org.jdbi.v3.core.mapper;

import java.lang.reflect.Type;
import java.util.Optional;
import org.jdbi.v3.core.config.ConfigRegistry;
import org.jdbi.v3.core.generic.GenericTypes;
import org.jdbi.v3.core.mapper.RowMapper;
import org.jdbi.v3.core.mapper.RowMapperFactory;

class InferredRowMapperFactory
implements RowMapperFactory {
    private final Type maps;
    private final RowMapper<?> mapper;

    InferredRowMapperFactory(RowMapper<?> mapper) {
        this.maps = GenericTypes.findGenericParameter(mapper.getClass(), RowMapper.class).orElseThrow(() -> new UnsupportedOperationException("Must use a concretely typed RowMapper here"));
        this.mapper = mapper;
    }

    @Override
    public Optional<RowMapper<?>> build(Type type, ConfigRegistry config) {
        return this.maps.equals(type) ? Optional.of(this.mapper) : Optional.empty();
    }
}

