/*
 * Decompiled with CFR 0.152.
 */
package org.jdbi.v3.core.config;

import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import org.jdbi.v3.core.config.JdbiCaches;
import org.jdbi.v3.core.config.JdbiConfig;

public class ConfigRegistry {
    private final Object createLock = new Object();
    private final Map<Class<? extends JdbiConfig<?>>, JdbiConfig<?>> configs = new ConcurrentHashMap();

    public ConfigRegistry() {
        this.configs.put(JdbiCaches.class, new JdbiCaches());
    }

    private ConfigRegistry(ConfigRegistry that) {
        that.configs.forEach((type, config) -> {
            Object copy = config.createCopy();
            copy.setRegistry(this);
            this.configs.put((Class<JdbiConfig<?>>)type, (JdbiConfig<?>)copy);
        });
    }

    public <C extends JdbiConfig<C>> C get(Class<C> configClass) {
        JdbiConfig<?> lookup = this.configs.get(configClass);
        if (lookup != null) {
            return (C)((JdbiConfig)configClass.cast(lookup));
        }
        Object object = this.createLock;
        synchronized (object) {
            try {
                JdbiConfig config = (JdbiConfig)configClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                config.setRegistry(this);
                return (C)Optional.ofNullable(configClass.cast(this.configs.putIfAbsent(configClass, config))).orElse(config);
            }
            catch (ReflectiveOperationException e) {
                throw new IllegalStateException("Unable to instantiate config class " + configClass + ". Is there a public no-arg constructor?", e);
            }
        }
    }

    public ConfigRegistry createCopy() {
        return new ConfigRegistry(this);
    }
}

