/*
 * Decompiled with CFR 0.152.
 */
package org.jdbi.v3.core.mapper;

import java.lang.reflect.Type;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Optional;
import org.jdbi.v3.core.generic.GenericTypes;
import org.jdbi.v3.core.mapper.ColumnMapper;
import org.jdbi.v3.core.mapper.NoSuchMapperException;
import org.jdbi.v3.core.statement.StatementContext;

class OptionalMapper<T>
implements ColumnMapper<Optional<T>> {
    private final Type type;

    private OptionalMapper(Type type) {
        this.type = type;
    }

    public static ColumnMapper<?> of(Type type) {
        return new OptionalMapper(type);
    }

    @Override
    public Optional<T> map(ResultSet r, int columnNumber, StatementContext ctx) throws SQLException {
        ColumnMapper<?> mapper = ctx.findColumnMapperFor(GenericTypes.findGenericParameter(this.type, Optional.class).orElseThrow(() -> new NoSuchMapperException("No mapper for raw Optional type"))).orElseThrow(() -> new NoSuchMapperException("No mapper for type " + this.type + " nested in Optional"));
        return Optional.ofNullable(mapper.map(r, columnNumber, ctx));
    }
}

