/*
 * Decompiled with CFR 0.152.
 */
package org.jdbi.v3.core.locator;

import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import java.util.WeakHashMap;
import java.util.concurrent.ConcurrentHashMap;
import org.antlr.v4.runtime.CharStreams;
import org.jdbi.v3.core.internal.SqlScriptParser;
import org.jdbi.v3.core.locator.internal.ClasspathBuilder;

public final class ClasspathSqlLocator {
    private static final SqlScriptParser SQL_SCRIPT_PARSER = new SqlScriptParser((t, sb) -> sb.append(t.getText()));
    private static final Map<ClassLoader, Map<String, String>> CACHE = Collections.synchronizedMap(new WeakHashMap());
    private static final String SQL_EXTENSION = "sql";

    private ClasspathSqlLocator() {
    }

    public static String findSqlOnClasspath(Class<?> type, String methodName) {
        String path = new ClasspathBuilder().appendFullyQualifiedClassName(type).appendVerbatim(methodName).setExtension(SQL_EXTENSION).build();
        return ClasspathSqlLocator.getResourceOnClasspath(type.getClassLoader(), path);
    }

    public static String findSqlOnClasspath(String name) {
        ClasspathBuilder builder = new ClasspathBuilder().appendDotPath(name).setExtension(SQL_EXTENSION);
        return ClasspathSqlLocator.getResourceOnClasspath(ClasspathSqlLocator.selectClassLoader(), builder.build());
    }

    public static String getResourceOnClasspath(String path) {
        return ClasspathSqlLocator.getResourceOnClasspath(ClasspathSqlLocator.selectClassLoader(), path);
    }

    public static String getResourceOnClasspath(ClassLoader classLoader, String path) {
        return CACHE.computeIfAbsent(classLoader, x -> new ConcurrentHashMap()).computeIfAbsent(path, x -> ClasspathSqlLocator.readResource(classLoader, path));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static String readResource(ClassLoader classLoader, String path) {
        try (InputStream is = ClasspathSqlLocator.openStream(classLoader, path);){
            String string = SQL_SCRIPT_PARSER.parse(CharStreams.fromStream((InputStream)is));
            return string;
        }
        catch (IOException e) {
            throw new UncheckedIOException("Unable to read classpath resource at " + path, e);
        }
    }

    private static InputStream openStream(ClassLoader classLoader, String path) {
        InputStream is = classLoader.getResourceAsStream(path);
        if (is == null) {
            throw new IllegalArgumentException("Cannot find classpath resource at " + path);
        }
        return is;
    }

    private static ClassLoader selectClassLoader() {
        return Optional.ofNullable(Thread.currentThread().getContextClassLoader()).orElseGet(ClasspathSqlLocator.class::getClassLoader);
    }
}

