/*
 * Decompiled with CFR 0.152.
 */
package org.jdbi.v3.core.generic;

import io.leangen.geantyref.GenericTypeReflector;
import io.leangen.geantyref.TypeFactory;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.Map;
import java.util.Optional;
import org.jdbi.v3.core.internal.UtilityClassException;

public class GenericTypes {
    private static final TypeVariable<Class<Map>> KEY;
    private static final TypeVariable<Class<Map>> VALUE;

    private GenericTypes() {
        throw new UtilityClassException();
    }

    public static Class<?> getErasedType(Type type) {
        return GenericTypeReflector.erase((Type)type);
    }

    public static Optional<Type> findGenericParameter(Type type, Class<?> parameterizedSupertype) {
        return GenericTypes.findGenericParameter(type, parameterizedSupertype, 0);
    }

    public static Optional<Type> findGenericParameter(Type type, Class<?> parameterizedSupertype, int n) {
        return Optional.ofNullable(GenericTypeReflector.getTypeParameter((Type)type, parameterizedSupertype.getTypeParameters()[n]));
    }

    public static Type resolveType(Type type, Type contextType) {
        return GenericTypeReflector.resolveType((Type)type, (Type)contextType);
    }

    public static boolean isArray(Type type) {
        return type instanceof Class && ((Class)type).isArray();
    }

    public static Type resolveMapEntryType(Type mapType) {
        Type keyType = GenericTypes.resolveType(KEY, mapType);
        Type valueType = GenericTypes.resolveType(VALUE, mapType);
        return GenericTypes.resolveMapEntryType(keyType, valueType);
    }

    public static Type resolveMapEntryType(Type keyType, Type valueType) {
        return TypeFactory.parameterizedClass(Map.Entry.class, (Type[])new Type[]{keyType, valueType});
    }

    public static Type parameterizeClass(Class<?> clazz, Type ... arguments) {
        return TypeFactory.parameterizedClass(clazz, (Type[])arguments);
    }

    static {
        TypeVariable<Class<T>>[] mapParams = Map.class.getTypeParameters();
        KEY = mapParams[0];
        VALUE = mapParams[1];
    }
}

