/*
 * Decompiled with CFR 0.152.
 */
package org.jdbi.v3.core.mapper.reflect;

import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.lang.reflect.Parameter;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.WeakHashMap;
import java.util.function.Supplier;
import java.util.stream.Stream;
import org.jdbi.v3.core.internal.exceptions.Sneaky;
import org.jdbi.v3.core.mapper.reflect.InstanceFactory;

class ConstructorInstanceFactory<T>
extends InstanceFactory<T> {
    private static final MethodHandles.Lookup LOOKUP = MethodHandles.lookup();
    private static final Map<Constructor<?>, ConstructorHandleAndTypes> CONSTRUCTOR_CACHE = Collections.synchronizedMap(new WeakHashMap());
    private final Constructor<T> constructor;
    private final List<Type> types;
    private final MethodHandle constructorHandle;

    ConstructorInstanceFactory(Constructor<T> constructor) {
        super(constructor);
        this.constructor = Objects.requireNonNull(constructor, "constructor is null");
        ConstructorHandleAndTypes constructorHandleAndTypes = ConstructorInstanceFactory.getConstructorHandleAndTypes(constructor, () -> super.getTypes());
        this.types = constructorHandleAndTypes.getTypes();
        this.constructorHandle = constructorHandleAndTypes.getConstructorHandle();
    }

    @Override
    List<Type> getTypes() {
        return this.types;
    }

    @Override
    T newInstance(Object ... params) {
        try {
            return (T)this.constructorHandle.invokeWithArguments(params);
        }
        catch (Throwable e) {
            throw Sneaky.throwAnyway(e);
        }
    }

    @Override
    public String toString() {
        return this.constructor.toString();
    }

    private static <T> boolean isGenericInformationLost(Constructor<T> factory) {
        if ((long)factory.getParameters().length != ConstructorInstanceFactory.getFields(factory).count()) {
            return false;
        }
        boolean lossDetected = false;
        for (int i = 0; i < factory.getParameters().length; ++i) {
            Parameter parameter = factory.getParameters()[i];
            Field field = factory.getDeclaringClass().getDeclaredFields()[i];
            if (!parameter.getName().equals(field.getName()) || !parameter.getType().equals(field.getType())) {
                return false;
            }
            if (parameter.getType().getTypeParameters().length <= 0 || parameter.getParameterizedType().equals(field.getGenericType())) continue;
            lossDetected = true;
        }
        return lossDetected;
    }

    private static <T> ConstructorHandleAndTypes getConstructorHandleAndTypes(Constructor<T> constructor, Supplier<List<Type>> defaultSupplier) {
        return CONSTRUCTOR_CACHE.computeIfAbsent(constructor, ctor -> ConstructorInstanceFactory.computeConstructorHandleAndTypes(ctor, defaultSupplier));
    }

    private static <T> ConstructorHandleAndTypes computeConstructorHandleAndTypes(Constructor<T> constructor, Supplier<List<Type>> defaultSupplier) {
        MethodHandle constructorMethodHandle = ConstructorInstanceFactory.getConstructorMethodHandle(constructor);
        if (ConstructorInstanceFactory.isGenericInformationLost(constructor)) {
            return new ConstructorHandleAndTypes(constructorMethodHandle, ConstructorInstanceFactory.getFields(constructor).map(Field::getGenericType).toList());
        }
        return new ConstructorHandleAndTypes(constructorMethodHandle, defaultSupplier.get());
    }

    private static <T> MethodHandle getConstructorMethodHandle(Constructor<T> constructor) {
        try {
            return LOOKUP.unreflectConstructor(constructor).asFixedArity();
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    private static <T> Stream<Field> getFields(Constructor<T> constructor) {
        return Arrays.stream(constructor.getDeclaringClass().getDeclaredFields()).filter(field -> !Modifier.isStatic(field.getModifiers()));
    }

    private static class ConstructorHandleAndTypes {
        private final MethodHandle constructorHandle;
        private final List<Type> types;

        ConstructorHandleAndTypes(MethodHandle constructorHandle, List<Type> types) {
            this.constructorHandle = Objects.requireNonNull(constructorHandle, "constructorHandle is null");
            this.types = Objects.requireNonNull(types, "types is null");
        }

        public MethodHandle getConstructorHandle() {
            return this.constructorHandle;
        }

        public List<Type> getTypes() {
            return this.types;
        }
    }
}

