/*
 * Decompiled with CFR 0.152.
 */
package org.jdbi.v3.core.extension;

import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Objects;
import java.util.Set;
import org.jdbi.v3.core.config.ConfigRegistry;
import org.jdbi.v3.core.extension.BuiltInExtensionHandler;
import org.jdbi.v3.core.extension.ConfigCustomizerFactory;
import org.jdbi.v3.core.extension.ExtensionFactory;
import org.jdbi.v3.core.extension.ExtensionHandler;
import org.jdbi.v3.core.extension.ExtensionHandlerCustomizer;
import org.jdbi.v3.core.extension.ExtensionHandlerFactory;
import org.jdbi.v3.core.extension.ExtensionMetadata;
import org.jdbi.v3.core.extension.Extensions;
import org.jdbi.v3.core.extension.FilteringExtensionHandlerFactory;
import org.jdbi.v3.core.extension.HandleSupplier;
import org.jdbi.v3.core.internal.JdbiClassUtils;

final class ExtensionFactoryDelegate
implements ExtensionFactory {
    private final ExtensionFactory delegatedFactory;

    ExtensionFactoryDelegate(ExtensionFactory delegatedFactory) {
        this.delegatedFactory = delegatedFactory;
    }

    @Override
    public boolean accepts(Class<?> extensionType) {
        return this.delegatedFactory.accepts(extensionType);
    }

    ExtensionFactory getDelegatedFactory() {
        return this.delegatedFactory;
    }

    @Override
    public Collection<ExtensionHandlerFactory> getExtensionHandlerFactories(ConfigRegistry config) {
        return Collections.unmodifiableCollection(this.delegatedFactory.getExtensionHandlerFactories(config).stream().map(FilteringExtensionHandlerFactory::forDelegate).toList());
    }

    @Override
    public Collection<ExtensionHandlerCustomizer> getExtensionHandlerCustomizers(ConfigRegistry config) {
        return this.delegatedFactory.getExtensionHandlerCustomizers(config);
    }

    @Override
    public Collection<ConfigCustomizerFactory> getConfigCustomizerFactories(ConfigRegistry config) {
        return this.delegatedFactory.getConfigCustomizerFactories(config);
    }

    @Override
    public void buildExtensionMetadata(ExtensionMetadata.Builder builder) {
        this.delegatedFactory.buildExtensionMetadata(builder);
    }

    @Override
    public Set<ExtensionFactory.FactoryFlag> getFactoryFlags() {
        return this.delegatedFactory.getFactoryFlags();
    }

    @Override
    public <E> E attach(Class<E> extensionType, HandleSupplier handleSupplier) {
        Set<ExtensionFactory.FactoryFlag> factoryFlags = this.getFactoryFlags();
        if (factoryFlags.contains((Object)ExtensionFactory.FactoryFlag.DONT_USE_PROXY)) {
            return this.delegatedFactory.attach(extensionType, handleSupplier);
        }
        if (extensionType == null || !extensionType.isInterface()) {
            throw new IllegalArgumentException(String.format("Can not attach %s as an extension with %s", extensionType, this.delegatedFactory.getClass().getSimpleName()));
        }
        ConfigRegistry config = handleSupplier.getConfig();
        Extensions extensions = config.get(Extensions.class);
        extensions.onCreateProxy();
        ExtensionMetadata extensionMetaData = extensions.findMetadata(extensionType, this.delegatedFactory);
        ConfigRegistry instanceConfig = extensionMetaData.createInstanceConfiguration(config);
        HashMap<JdbiClassUtils.MethodKey, ExtensionMetadata.ExtensionHandlerInvoker> handlers = new HashMap<JdbiClassUtils.MethodKey, ExtensionMetadata.ExtensionHandlerInvoker>();
        Object proxy = Proxy.newProxyInstance(extensionType.getClassLoader(), new Class[]{extensionType}, (proxyInstance, method, args) -> ((ExtensionMetadata.ExtensionHandlerInvoker)handlers.get(JdbiClassUtils.MethodKey.methodKey(method))).invoke(args));
        Object delegatedInstance = factoryFlags.contains((Object)ExtensionFactory.FactoryFlag.NON_VIRTUAL_FACTORY) ? this.delegatedFactory.attach(extensionType, handleSupplier) : proxy;
        ExtensionHandler toStringHandler = (methodConfig, target) -> (h, args) -> "Jdbi extension proxy for " + extensionType.getName() + "@" + Integer.toHexString(proxy.hashCode());
        JdbiClassUtils.MethodKey methodKey = JdbiClassUtils.MethodKey.methodKey(JdbiClassUtils.TOSTRING_METHOD);
        ExtensionMetadata extensionMetadata = extensionMetaData;
        Objects.requireNonNull(extensionMetadata);
        handlers.put(methodKey, new ExtensionMetadata.ExtensionHandlerInvoker(extensionMetadata, proxy, JdbiClassUtils.TOSTRING_METHOD, toStringHandler, handleSupplier, instanceConfig));
        JdbiClassUtils.MethodKey methodKey2 = JdbiClassUtils.MethodKey.methodKey(JdbiClassUtils.EQUALS_METHOD);
        ExtensionMetadata extensionMetadata2 = extensionMetaData;
        Objects.requireNonNull(extensionMetadata2);
        handlers.put(methodKey2, new ExtensionMetadata.ExtensionHandlerInvoker(extensionMetadata2, proxy, JdbiClassUtils.EQUALS_METHOD, BuiltInExtensionHandler.EQUALS_HANDLER, handleSupplier, instanceConfig));
        JdbiClassUtils.MethodKey methodKey3 = JdbiClassUtils.MethodKey.methodKey(JdbiClassUtils.HASHCODE_METHOD);
        ExtensionMetadata extensionMetadata3 = extensionMetaData;
        Objects.requireNonNull(extensionMetadata3);
        handlers.put(methodKey3, new ExtensionMetadata.ExtensionHandlerInvoker(extensionMetadata3, proxy, JdbiClassUtils.HASHCODE_METHOD, BuiltInExtensionHandler.HASHCODE_HANDLER, handleSupplier, instanceConfig));
        extensionMetaData.getExtensionMethods().forEach(method -> handlers.put(JdbiClassUtils.MethodKey.methodKey(method), extensionMetaData.createExtensionHandlerInvoker(delegatedInstance, (Method)method, handleSupplier, instanceConfig)));
        extensionMetaData.getFinalizer().ifPresent(method -> {
            JdbiClassUtils.MethodKey methodKey = JdbiClassUtils.MethodKey.methodKey(method);
            ExtensionMetadata extensionMetadata = extensionMetaData;
            Objects.requireNonNull(extensionMetadata);
            handlers.put(methodKey, new ExtensionMetadata.ExtensionHandlerInvoker(extensionMetadata, proxy, (Method)method, BuiltInExtensionHandler.NULL_HANDLER, handleSupplier, instanceConfig));
        });
        return extensionType.cast(proxy);
    }

    public String toString() {
        return "ExtensionFactoryDelegate for " + this.delegatedFactory.toString();
    }
}

