/*
 * Decompiled with CFR 0.152.
 */
package org.jdbi.v3.core.statement;

import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.List;
import org.jdbi.v3.core.statement.Binding;
import org.jdbi.v3.core.statement.ParsedParameters;
import org.jdbi.v3.core.statement.SqlStatements;
import org.jdbi.v3.core.statement.StatementContext;
import org.jdbi.v3.core.statement.UnableToCreateStatementException;

class ArgumentBinder {
    private ArgumentBinder() {
        throw new UnsupportedOperationException("utility class");
    }

    static void bind(ParsedParameters parameters, Binding binding, PreparedStatement statement, StatementContext context) {
        if (parameters.isPositional()) {
            ArgumentBinder.bindPositional(parameters, binding, statement, context);
        } else {
            ArgumentBinder.bindNamed(parameters, binding, statement, context);
        }
    }

    private static void bindPositional(ParsedParameters params, Binding binding, PreparedStatement statement, StatementContext context) {
        boolean moreArgumentsProvidedThanDeclared = binding.findForPosition(params.getParameterCount()).isPresent();
        if (moreArgumentsProvidedThanDeclared && !context.getConfig(SqlStatements.class).isUnusedBindingAllowed()) {
            throw new UnableToCreateStatementException("Superfluous positional param at (0 based) position " + params.getParameterCount(), context);
        }
        for (int i = 0; i < params.getParameterCount(); ++i) {
            int index = i;
            try {
                binding.findForPosition(i).orElseThrow(() -> new UnableToCreateStatementException("Missing positional param at (0 based) position " + index, context)).apply(i + 1, statement, context);
                continue;
            }
            catch (SQLException e) {
                throw new UnableToCreateStatementException("Exception while binding positional param at (0 based) position " + i, e, context);
            }
        }
    }

    private static void bindNamed(ParsedParameters params, Binding binding, PreparedStatement statement, StatementContext context) {
        boolean argumentsProvidedButNoneDeclared;
        List<String> paramNames = params.getParameterNames();
        boolean bl = argumentsProvidedButNoneDeclared = paramNames.isEmpty() && !binding.isEmpty();
        if (argumentsProvidedButNoneDeclared && !context.getConfig(SqlStatements.class).isUnusedBindingAllowed()) {
            throw new UnableToCreateStatementException(String.format("Superfluous named parameters provided while the query declares none: '%s'.", binding), context);
        }
        for (int i = 0; i < paramNames.size(); ++i) {
            String name = paramNames.get(i);
            try {
                binding.findForName(name, context).orElseThrow(() -> new UnableToCreateStatementException(String.format("Missing named parameter '%s'.", name), context)).apply(i + 1, statement, context);
                continue;
            }
            catch (SQLException e) {
                throw new UnableToCreateStatementException(String.format("Exception while binding named parameter '%s'", name), e, context);
            }
        }
    }
}

