/*
 * Decompiled with CFR 0.152.
 */
package org.jdbi.v3.core;

import java.lang.invoke.MethodHandles;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import org.jdbi.v3.core.Jdbi;
import org.jdbi.v3.core.internal.JdbiThreadLocals;

class OnDemandExtensions {
    private static final Method EQUALS_METHOD;
    private static final Method HASHCODE_METHOD;
    private static final Method TOSTRING_METHOD;

    private OnDemandExtensions() {
        throw new UnsupportedOperationException("utility class");
    }

    static <E> E create(Jdbi db, Class<E> extensionType) {
        ThreadLocal threadExtension = new ThreadLocal();
        InvocationHandler handler = (proxy, method, args) -> {
            if (EQUALS_METHOD.equals(method)) {
                return proxy == args[0];
            }
            if (HASHCODE_METHOD.equals(method)) {
                return System.identityHashCode(proxy);
            }
            if (TOSTRING_METHOD.equals(method)) {
                return extensionType + "@" + Integer.toHexString(System.identityHashCode(proxy));
            }
            if (threadExtension.get() != null) {
                return OnDemandExtensions.invoke(threadExtension.get(), method, args);
            }
            return db.withExtension(extensionType, extension -> JdbiThreadLocals.invokeInContext(threadExtension, extension, () -> OnDemandExtensions.invoke(extension, method, args)));
        };
        return extensionType.cast(Proxy.newProxyInstance(extensionType.getClassLoader(), new Class[]{extensionType}, handler));
    }

    private static Object invoke(Object target, Method method, Object[] args) throws Exception {
        try {
            if (Proxy.isProxyClass(target.getClass())) {
                return Proxy.getInvocationHandler(target).invoke(target, method, args);
            }
            return MethodHandles.lookup().unreflect(method).bindTo(target).invokeWithArguments(args);
        }
        catch (Error | Exception e) {
            throw e;
        }
        catch (Throwable t) {
            throw new RuntimeException(t);
        }
    }

    static {
        try {
            EQUALS_METHOD = Object.class.getMethod("equals", Object.class);
            HASHCODE_METHOD = Object.class.getMethod("hashCode", new Class[0]);
            TOSTRING_METHOD = Object.class.getMethod("toString", new Class[0]);
        }
        catch (NoSuchMethodException wat) {
            throw new IllegalStateException("JVM error", wat);
        }
    }
}

