/*
 * Decompiled with CFR 0.152.
 */
package org.jdbi.v3.core.statement.internal;

import java.lang.reflect.Method;
import org.jdbi.v3.core.statement.JdbiStatementEvent;
import org.jdbi.v3.core.statement.internal.NoStatementEvent;
import org.jdbi.v3.core.statement.internal.OptionalEvent;

public final class JfrSupport {
    private static final boolean JFR_AVAILABLE = ModuleLayer.boot().findModule("jdk.jfr").isPresent();
    private static final boolean FLIGHT_RECORDER_AVAILABLE;

    private JfrSupport() {
        throw new AssertionError((Object)"JfrSupport can not be instantiated");
    }

    public static boolean isJfrAvailable() {
        return JFR_AVAILABLE;
    }

    public static boolean isFlightRecorderAvailable() {
        return FLIGHT_RECORDER_AVAILABLE;
    }

    public static OptionalEvent newStatementEvent() {
        if (JfrSupport.isJfrAvailable()) {
            return Holder.newEvent();
        }
        return new NoStatementEvent();
    }

    static {
        boolean flightRecorderAvailable = false;
        if (JfrSupport.isJfrAvailable()) {
            try {
                Class<?> flightRecorder = Class.forName("jdk.jfr.FlightRecorder");
                Method register = flightRecorder.getMethod("register", Class.class);
                register.invoke(null, JdbiStatementEvent.class);
                Method isAvailable = flightRecorder.getMethod("isAvailable", new Class[0]);
                flightRecorderAvailable = (Boolean)isAvailable.invoke(null, new Object[0]);
            }
            catch (ReflectiveOperationException e) {
                throw new ExceptionInInitializerError(e);
            }
        }
        FLIGHT_RECORDER_AVAILABLE = flightRecorderAvailable;
    }

    private static final class Holder {
        private Holder() {
        }

        public static OptionalEvent newEvent() {
            return new JdbiStatementEvent();
        }
    }
}

