/*
 * Decompiled with CFR 0.152.
 */
package org.jdbi.v3.core.statement;

import java.io.InputStream;
import java.io.Reader;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.net.URI;
import java.net.URL;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jdbi.v3.core.Handle;
import org.jdbi.v3.core.argument.Argument;
import org.jdbi.v3.core.argument.BeanPropertyArguments;
import org.jdbi.v3.core.argument.CharacterStreamArgument;
import org.jdbi.v3.core.argument.InputStreamArgument;
import org.jdbi.v3.core.argument.NamedArgumentFinder;
import org.jdbi.v3.core.argument.NullArgument;
import org.jdbi.v3.core.argument.ObjectArgument;
import org.jdbi.v3.core.argument.ObjectFieldArguments;
import org.jdbi.v3.core.argument.ObjectMethodArguments;
import org.jdbi.v3.core.argument.internal.NamedArgumentFinderFactory;
import org.jdbi.v3.core.argument.internal.PojoPropertyArguments;
import org.jdbi.v3.core.generic.GenericType;
import org.jdbi.v3.core.generic.GenericTypes;
import org.jdbi.v3.core.internal.IterableLike;
import org.jdbi.v3.core.mapper.Mappers;
import org.jdbi.v3.core.mapper.RowMapper;
import org.jdbi.v3.core.qualifier.NVarchar;
import org.jdbi.v3.core.qualifier.QualifiedType;
import org.jdbi.v3.core.statement.ArgumentBinder;
import org.jdbi.v3.core.statement.BaseStatement;
import org.jdbi.v3.core.statement.Binding;
import org.jdbi.v3.core.statement.DefineNamedBindingsStatementCustomizer;
import org.jdbi.v3.core.statement.EmptyHandling;
import org.jdbi.v3.core.statement.JdbiStatementEvent;
import org.jdbi.v3.core.statement.ParsedSql;
import org.jdbi.v3.core.statement.SqlLoggerUtil;
import org.jdbi.v3.core.statement.SqlStatements;
import org.jdbi.v3.core.statement.StatementContext;
import org.jdbi.v3.core.statement.StatementCustomizers;
import org.jdbi.v3.core.statement.UnableToCreateStatementException;
import org.jdbi.v3.core.statement.UnableToExecuteStatementException;
import org.jdbi.v3.core.statement.internal.JfrSupport;
import org.jdbi.v3.core.statement.internal.OptionalEvent;
import org.jdbi.v3.meta.Beta;

public abstract class SqlStatement<This extends SqlStatement<This>>
extends BaseStatement<This> {
    private final String sql;
    PreparedStatement stmt;

    SqlStatement(Handle handle, CharSequence sql) {
        super(handle);
        this.sql = sql.toString();
        this.getContext().setConnection(handle.getConnection()).setRawSql(this.sql);
    }

    protected Binding getBinding() {
        return this.getContext().getBinding();
    }

    protected String getSql() {
        return this.sql;
    }

    public This setQueryTimeout(int seconds) {
        return (This)((SqlStatement)this.addCustomizer(StatementCustomizers.statementTimeout(seconds)));
    }

    public This cleanupHandleCommit() {
        return this.cleanupHandle(Handle::commit);
    }

    public This cleanupHandleRollback() {
        return this.cleanupHandle(Handle::rollback);
    }

    private This cleanupHandle(Consumer<Handle> action) {
        this.getContext().addCleanable(() -> {
            Handle handle = this.getHandle();
            if (handle != null) {
                if (handle.isInTransaction()) {
                    action.accept(handle);
                }
                handle.close();
            }
        });
        return (This)((SqlStatement)this.typedThis);
    }

    public This bind(int position, Argument argument) {
        this.getBinding().addPositional(position, argument);
        return (This)this;
    }

    public This bind(String name, Argument argument) {
        this.getBinding().addNamed(name, argument);
        return (This)((SqlStatement)this.typedThis);
    }

    public This bindBean(Object bean) {
        return this.bindBean(null, bean);
    }

    public This bindBean(String prefix, Object bean) {
        if (bean != null) {
            return this.bindNamedArgumentFinder(NamedArgumentFinderFactory.BEAN, prefix, bean, bean.getClass(), () -> new BeanPropertyArguments(prefix, bean, this.getConfig()));
        }
        return (This)((SqlStatement)this.typedThis);
    }

    @Beta
    public This bindPojo(Object pojo) {
        return this.bindPojo(null, pojo);
    }

    @Beta
    public This bindPojo(String prefix, Object pojo) {
        return this.bindPojo(prefix, pojo, pojo.getClass());
    }

    @Beta
    public This bindPojo(Object pojo, Type type) {
        return this.bindPojo(null, pojo, type);
    }

    @Beta
    public This bindPojo(String prefix, Object pojo, Type type) {
        if (pojo != null) {
            return this.bindNamedArgumentFinder(NamedArgumentFinderFactory.POJO, prefix, pojo, type, () -> new PojoPropertyArguments(prefix, pojo, type, this.getConfig()));
        }
        return (This)((SqlStatement)this.typedThis);
    }

    @Beta
    public This bindPojo(Object pojo, GenericType<?> type) {
        return this.bindPojo(null, pojo, type.getType());
    }

    @Beta
    public This bindPojo(String prefix, Object pojo, GenericType<?> type) {
        return this.bindPojo(prefix, pojo, type.getType());
    }

    public This bindFields(Object object) {
        return this.bindFields(null, object);
    }

    public This bindFields(String prefix, Object object) {
        if (object != null) {
            return this.bindNamedArgumentFinder(NamedArgumentFinderFactory.FIELDS, prefix, object, object.getClass(), () -> new ObjectFieldArguments(prefix, object));
        }
        return (This)((SqlStatement)this.typedThis);
    }

    public This bindMethods(Object object) {
        return this.bindMethods(null, object);
    }

    public This bindMethods(String prefix, Object object) {
        if (object != null) {
            return this.bindNamedArgumentFinder(NamedArgumentFinderFactory.METHODS, prefix, object, object.getClass(), () -> new ObjectMethodArguments(prefix, object));
        }
        return (This)((SqlStatement)this.typedThis);
    }

    public This bindMap(Map<String, ?> map) {
        if (map != null) {
            map.forEach(this::bind);
        }
        return (This)((SqlStatement)this.typedThis);
    }

    public This bindNamedArgumentFinder(NamedArgumentFinder namedArgumentFinder) {
        if (namedArgumentFinder != null) {
            this.getBinding().addNamedArgumentFinder(namedArgumentFinder);
        }
        return (This)((SqlStatement)this.typedThis);
    }

    This bindNamedArgumentFinder(NamedArgumentFinderFactory factory, String prefix, Object value, Type type, Supplier<NamedArgumentFinder> namedArgumentFinder) {
        return this.bindNamedArgumentFinder(namedArgumentFinder.get());
    }

    public final This bind(int position, Character value) {
        return this.bind(position, Character.class, (Object)value);
    }

    public final This bind(String name, Character value) {
        return this.bind(name, Character.class, (Object)value);
    }

    public final This bind(int position, String value) {
        return this.bind(position, String.class, (Object)value);
    }

    public final This bind(String name, String value) {
        return this.bind(name, String.class, (Object)value);
    }

    public final This bindNVarchar(int position, String value) {
        return this.bindByType(position, (Object)value, QualifiedType.of(String.class).with(NVarchar.class));
    }

    public final This bindNVarchar(String name, String value) {
        return this.bindByType(name, (Object)value, QualifiedType.of(String.class).with(NVarchar.class));
    }

    public final This bind(int position, int value) {
        return this.bind(position, Integer.TYPE, (Object)value);
    }

    public final This bind(int position, Integer value) {
        return this.bind(position, Integer.class, (Object)value);
    }

    public final This bind(String name, int value) {
        return this.bind(name, Integer.TYPE, (Object)value);
    }

    public final This bind(String name, Integer value) {
        return this.bind(name, Integer.class, (Object)value);
    }

    public final This bind(int position, char value) {
        return this.bind(position, Character.TYPE, (Object)Character.valueOf(value));
    }

    public final This bind(String name, char value) {
        return this.bind(name, Character.TYPE, (Object)Character.valueOf(value));
    }

    public final This bindASCIIStream(int position, InputStream value, int length) {
        return this.bind(position, (Argument)new InputStreamArgument(value, length, true));
    }

    public final This bindASCIIStream(String name, InputStream value, int length) {
        return this.bind(name, (Argument)new InputStreamArgument(value, length, true));
    }

    public final This bind(int position, BigDecimal value) {
        return this.bind(position, BigDecimal.class, (Object)value);
    }

    public final This bind(String name, BigDecimal value) {
        return this.bind(name, BigDecimal.class, (Object)value);
    }

    public final This bindBinaryStream(int position, InputStream value, int length) {
        return this.bind(position, (Argument)new InputStreamArgument(value, length, false));
    }

    public final This bindBinaryStream(String name, InputStream value, int length) {
        return this.bind(name, (Argument)new InputStreamArgument(value, length, false));
    }

    public final This bind(int position, Blob value) {
        return this.bind(position, Blob.class, (Object)value);
    }

    public final This bind(String name, Blob value) {
        return this.bind(name, Blob.class, (Object)value);
    }

    public final This bind(int position, boolean value) {
        return this.bind(position, Boolean.TYPE, (Object)value);
    }

    public final This bind(int position, Boolean value) {
        return this.bind(position, Boolean.class, (Object)value);
    }

    private This bind(int position, Class<?> type, Object value) {
        return this.bindByType(position, value, type);
    }

    private This bind(String name, Class<?> type, Object value) {
        return this.bindByType(name, value, type);
    }

    public final This bind(String name, boolean value) {
        return this.bindByType(name, (Object)value, Boolean.TYPE);
    }

    public final This bind(String name, Boolean value) {
        return this.bindByType(name, (Object)value, (Type)((Object)Boolean.class));
    }

    public final This bind(int position, byte value) {
        return this.bindByType(position, (Object)value, Byte.TYPE);
    }

    public final This bind(int position, Byte value) {
        return this.bindByType(position, (Object)value, (Type)((Object)Byte.class));
    }

    public final This bind(String name, byte value) {
        return this.bindByType(name, (Object)value, Byte.TYPE);
    }

    public final This bind(String name, Byte value) {
        return this.bindByType(name, (Object)value, (Type)((Object)Byte.class));
    }

    public final This bind(int position, byte[] value) {
        return this.bindByType(position, (Object)value, (Type)((Object)byte[].class));
    }

    public final This bind(String name, byte[] value) {
        return this.bindByType(name, (Object)value, (Type)((Object)byte[].class));
    }

    public final This bind(int position, Reader value, int length) {
        return this.bind(position, (Argument)new CharacterStreamArgument(value, length));
    }

    public final This bind(String name, Reader value, int length) {
        return this.bind(name, (Argument)new CharacterStreamArgument(value, length));
    }

    public final This bind(int position, Clob value) {
        return this.bindByType(position, (Object)value, (Type)((Object)Clob.class));
    }

    public final This bind(String name, Clob value) {
        return this.bindByType(name, (Object)value, (Type)((Object)Clob.class));
    }

    public final This bind(int position, Date value) {
        return this.bindByType(position, (Object)value, (Type)((Object)Date.class));
    }

    public final This bind(String name, Date value) {
        return this.bindByType(name, (Object)value, (Type)((Object)Date.class));
    }

    public final This bind(int position, java.util.Date value) {
        return this.bindByType(position, (Object)value, (Type)((Object)java.util.Date.class));
    }

    public final This bind(String name, java.util.Date value) {
        return this.bindByType(name, (Object)value, (Type)((Object)java.util.Date.class));
    }

    public final This bind(int position, double value) {
        return this.bindByType(position, (Object)value, Double.TYPE);
    }

    public final This bind(int position, Double value) {
        return this.bindByType(position, (Object)value, (Type)((Object)Double.class));
    }

    public final This bind(String name, double value) {
        return this.bindByType(name, (Object)value, Double.TYPE);
    }

    public final This bind(String name, Double value) {
        return this.bindByType(name, (Object)value, (Type)((Object)Double.class));
    }

    public final This bind(int position, float value) {
        return this.bindByType(position, (Object)Float.valueOf(value), Float.TYPE);
    }

    public final This bind(int position, Float value) {
        return this.bindByType(position, (Object)value, (Type)((Object)Float.class));
    }

    public final This bind(String name, float value) {
        return this.bindByType(name, (Object)Float.valueOf(value), Float.TYPE);
    }

    public final This bind(String name, Float value) {
        return this.bindByType(name, (Object)value, (Type)((Object)Float.class));
    }

    public final This bind(int position, long value) {
        return this.bindByType(position, (Object)value, Long.TYPE);
    }

    public final This bind(int position, Long value) {
        return this.bindByType(position, (Object)value, (Type)((Object)Long.class));
    }

    public final This bind(String name, long value) {
        return this.bindByType(name, (Object)value, Long.TYPE);
    }

    public final This bind(String name, Long value) {
        return this.bindByType(name, (Object)value, (Type)((Object)Long.class));
    }

    public final This bind(int position, Short value) {
        return this.bindByType(position, (Object)value, (Type)((Object)Short.class));
    }

    public final This bind(int position, short value) {
        return this.bindByType(position, (Object)value, Short.TYPE);
    }

    public final This bind(String name, short value) {
        return this.bindByType(name, (Object)value, Short.TYPE);
    }

    public final This bind(String name, Short value) {
        return this.bindByType(name, (Object)value, (Type)((Object)Short.class));
    }

    public final This bind(int position, Object value) {
        this.getBinding().addPositional(position, value);
        return (This)((SqlStatement)this.typedThis);
    }

    public final This bind(String name, Object value) {
        this.getBinding().addNamed(name, value);
        return (This)((SqlStatement)this.typedThis);
    }

    public final This bind(int position, Time value) {
        return this.bindByType(position, (Object)value, (Type)((Object)Time.class));
    }

    public final This bind(String name, Time value) {
        return this.bindByType(name, (Object)value, (Type)((Object)Time.class));
    }

    public final This bind(int position, Timestamp value) {
        return this.bindByType(position, (Object)value, (Type)((Object)Timestamp.class));
    }

    public final This bind(String name, Timestamp value) {
        return this.bindByType(name, (Object)value, (Type)((Object)Timestamp.class));
    }

    public final This bind(int position, URL value) {
        return this.bindByType(position, (Object)value, (Type)((Object)URL.class));
    }

    public final This bind(String name, URL value) {
        return this.bindByType(name, (Object)value, (Type)((Object)URL.class));
    }

    public final This bind(int position, URI value) {
        return this.bindByType(position, (Object)value, (Type)((Object)URI.class));
    }

    public final This bind(String name, URI value) {
        return this.bindByType(name, (Object)value, (Type)((Object)URI.class));
    }

    public final This bind(int position, UUID value) {
        return this.bindByType(position, (Object)value, (Type)((Object)UUID.class));
    }

    public final This bind(String name, UUID value) {
        return this.bindByType(name, (Object)value, (Type)((Object)UUID.class));
    }

    public final This bindByType(int position, Object value, Type argumentType) {
        return this.bindByType(position, value, QualifiedType.of(argumentType));
    }

    public final This bindByType(int position, Object value, GenericType<?> argumentType) {
        return this.bindByType(position, value, argumentType.getType());
    }

    public final This bindByType(int position, Object value, QualifiedType<?> argumentType) {
        this.getBinding().addPositional(position, value, argumentType);
        return (This)((SqlStatement)this.typedThis);
    }

    public final This bindByType(String name, Object value, Type argumentType) {
        return this.bindByType(name, value, QualifiedType.of(argumentType));
    }

    public final This bindByType(String name, Object value, GenericType<?> argumentType) {
        return this.bindByType(name, value, argumentType.getType());
    }

    public final This bindByType(String name, Object value, QualifiedType<?> argumentType) {
        this.getBinding().addNamed(name, value, argumentType);
        return (This)((SqlStatement)this.typedThis);
    }

    @SafeVarargs
    public final <T> This bindArray(String name, T ... array) {
        return this.bindArray(name, (Type)array.getClass().getComponentType(), (Object[])array);
    }

    @SafeVarargs
    public final <T> This bindArray(int pos, T ... array) {
        return this.bindArray(pos, (Type)array.getClass().getComponentType(), (Object[])array);
    }

    public final This bindArray(String name, Type elementType, Object ... array) {
        return this.bindByType(name, (Object)array, GenericTypes.arrayType(elementType));
    }

    public final This bindArray(int pos, Type elementType, Object ... array) {
        return this.bindByType(pos, (Object)array, GenericTypes.arrayType(elementType));
    }

    public final This bindArray(String name, Type elementType, Iterable<?> iterable) {
        return this.bindByType(name, iterable, GenericTypes.parameterizeClass(Iterable.class, elementType));
    }

    public final This bindArray(int pos, Type elementType, Iterable<?> iterable) {
        return this.bindByType(pos, iterable, GenericTypes.parameterizeClass(Iterable.class, elementType));
    }

    public final This bindArray(String name, Type elementType, Iterator<?> iterator) {
        return this.bindByType(name, iterator, GenericTypes.parameterizeClass(Iterator.class, elementType));
    }

    public final This bindArray(int pos, Type elementType, Iterator<?> iterator) {
        return this.bindByType(pos, iterator, GenericTypes.parameterizeClass(Iterator.class, elementType));
    }

    public final This bindNull(String name, int sqlType) {
        return this.bind(name, (Argument)new NullArgument(sqlType));
    }

    public final This bindNull(int position, int sqlType) {
        return this.bind(position, (Argument)new NullArgument(sqlType));
    }

    public final This bindBySqlType(String name, Object value, int sqlType) {
        return this.bind(name, ObjectArgument.of(value, sqlType));
    }

    public final This bindBySqlType(int position, Object value, int sqlType) {
        return this.bind(position, ObjectArgument.of(value, sqlType));
    }

    public final This bindList(String key, Object ... values) {
        return this.bindList((BiConsumer<SqlStatement, String>)EmptyHandling.THROW, key, values);
    }

    public final This bindList(BiConsumer<SqlStatement, String> onEmpty, String key, Object ... values) {
        return this.bindList(onEmpty, key, values == null ? null : Arrays.asList(values));
    }

    public final This bindList(String key, Iterable<?> values) {
        return this.bindList((BiConsumer<SqlStatement, String>)EmptyHandling.THROW, key, values);
    }

    public final This bindList(BiConsumer<SqlStatement, String> onEmpty, String key, Iterable<?> values) {
        return this.bindList(onEmpty, key, values == null ? null : IterableLike.toList(values));
    }

    public final This bindList(String key, Iterator<?> values) {
        return this.bindList((BiConsumer<SqlStatement, String>)EmptyHandling.THROW, key, values);
    }

    public final This bindList(BiConsumer<SqlStatement, String> onEmpty, String key, Iterator<?> values) {
        return this.bindList(onEmpty, key, values == null ? null : IterableLike.toList(values));
    }

    public final This bindList(BiConsumer<SqlStatement, String> onEmpty, String key, List<?> values) {
        if (values == null || values.isEmpty()) {
            onEmpty.accept(this, key);
            return (This)((SqlStatement)this.typedThis);
        }
        StringBuilder names = new StringBuilder();
        for (int i = 0; i < values.size(); ++i) {
            String name = "__" + key + "_" + i;
            if (i > 0) {
                names.append(',');
            }
            String paramName = this.getConfig().get(SqlStatements.class).getSqlParser().nameParameter(name, this.getContext());
            names.append(paramName);
            this.bind(name, values.get(i));
        }
        return (This)((SqlStatement)this.define(key, names.toString()));
    }

    public final This bindBeanList(String key, List<?> values, List<String> propertyNames) {
        if (values.isEmpty()) {
            throw new IllegalArgumentException(this.getClass().getSimpleName() + ".bindBeanList was called with no values.");
        }
        if (propertyNames.isEmpty()) {
            throw new IllegalArgumentException(this.getClass().getSimpleName() + ".bindBeanList was called with no properties.");
        }
        StringBuilder names = new StringBuilder();
        StatementContext ctx = this.getContext();
        for (int valueIndex = 0; valueIndex < values.size(); ++valueIndex) {
            if (valueIndex > 0) {
                names.append(',');
            }
            Object bean = values.get(valueIndex);
            BeanPropertyArguments beanProperties = new BeanPropertyArguments(null, bean, this.getConfig());
            names.append('(');
            for (int propertyIndex = 0; propertyIndex < propertyNames.size(); ++propertyIndex) {
                if (propertyIndex > 0) {
                    names.append(',');
                }
                String propertyName = propertyNames.get(propertyIndex);
                String name = "__" + key + "_" + valueIndex + "_" + propertyName;
                names.append(':').append(name);
                Argument argument = beanProperties.find(propertyName, ctx).orElseThrow(() -> new UnableToCreateStatementException("Unable to get " + propertyName + " argument for " + String.valueOf(bean), ctx));
                this.bind(name, argument);
            }
            names.append(')');
        }
        return (This)((SqlStatement)this.define(key, names.toString()));
    }

    public final This bindMethodsList(String key, Iterable<?> values, List<String> methodNames) {
        Iterator<?> valueIter = values.iterator();
        if (!valueIter.hasNext()) {
            throw new IllegalArgumentException(this.getClass().getSimpleName() + ".bindMethodsList was called with no values.");
        }
        if (methodNames.isEmpty()) {
            throw new IllegalArgumentException(this.getClass().getSimpleName() + ".bindMethodsList was called with no values.");
        }
        StringBuilder names = new StringBuilder();
        StatementContext ctx = this.getContext();
        int valueIndex = 0;
        while (valueIter.hasNext()) {
            if (valueIndex > 0) {
                names.append(',');
            }
            Object bean = valueIter.next();
            ObjectMethodArguments beanMethods = new ObjectMethodArguments(null, bean);
            names.append('(');
            for (int methodIndex = 0; methodIndex < methodNames.size(); ++methodIndex) {
                if (methodIndex > 0) {
                    names.append(',');
                }
                String methodName = methodNames.get(methodIndex);
                String name = key + valueIndex + "." + methodName;
                names.append(':').append(name);
                Argument argument = beanMethods.find(methodName, ctx).orElseThrow(() -> new UnableToCreateStatementException("Unable to get " + methodName + " argument for " + String.valueOf(bean), ctx));
                this.bind(name, argument);
            }
            names.append(')');
            ++valueIndex;
        }
        return (This)((SqlStatement)this.define(key, names.toString()));
    }

    public final This defineList(String key, Object ... values) {
        if (values.length == 0) {
            throw new IllegalArgumentException(this.getClass().getSimpleName() + ".defineList was called with no vararg values.");
        }
        if (Stream.of(values).anyMatch(Objects::isNull)) {
            throw new IllegalArgumentException(this.getClass().getSimpleName() + ".defineList was called with a vararg array containing null values.");
        }
        return this.defineList(key, Arrays.asList(values));
    }

    public final This defineList(String key, List<?> values) {
        if (values.isEmpty()) {
            throw new IllegalArgumentException(this.getClass().getSimpleName() + ".defineList was called with an empty list.");
        }
        if (values.stream().anyMatch(Objects::isNull)) {
            throw new IllegalArgumentException(this.getClass().getSimpleName() + ".defineList was called with a list containing null values.");
        }
        String value = values.stream().map(Object::toString).collect(Collectors.joining(", "));
        return (This)((SqlStatement)this.define(key, value));
    }

    @Beta
    public This defineNamedBindings() {
        return (This)((SqlStatement)this.addCustomizer(new DefineNamedBindingsStatementCustomizer()));
    }

    public String toString() {
        return String.format("%s[sql=%s, bindings=%s]", this.getClass().getSimpleName(), this.sql, this.getContext().getBinding());
    }

    PreparedStatement internalExecute() {
        StatementContext ctx = this.getContext();
        OptionalEvent evt = JfrSupport.newStatementEvent();
        evt.begin();
        this.beforeTemplating();
        ParsedSql parsedSql = this.parseSql();
        try {
            this.stmt = this.createStatement(parsedSql.getSql());
            this.getContext().addCleanable(() -> this.cleanupStatement(this.stmt));
            this.getConfig(SqlStatements.class).customize(this.stmt);
        }
        catch (SQLException e) {
            throw new UnableToCreateStatementException(e, ctx);
        }
        ctx.setStatement(this.stmt);
        this.beforeBinding();
        new ArgumentBinder(this.stmt, ctx, parsedSql.getParameters()).bind(this.getBinding());
        this.beforeExecution();
        this.attachJfrEvent(evt, ctx);
        try {
            SqlLoggerUtil.wrap(this.stmt::execute, ctx, this.getConfig(SqlStatements.class).getSqlLogger());
        }
        catch (SQLException e) {
            throw new UnableToExecuteStatementException(e, ctx);
        }
        this.afterExecution();
        return this.stmt;
    }

    PreparedStatement createStatement(String parsedSql) throws SQLException {
        return this.getHandle().getStatementBuilder().create(this.getHandle().getConnection(), parsedSql, this.getContext());
    }

    void cleanupStatement(PreparedStatement statement) throws SQLException {
        this.getHandle().getStatementBuilder().close(this.getHandle().getConnection(), this.sql, statement);
    }

    ParsedSql parseSql() {
        StatementContext ctx = this.getContext();
        SqlStatements statements = this.getConfig(SqlStatements.class);
        String renderedSql = statements.preparedRender(this.sql, ctx);
        ctx.setRenderedSql(renderedSql);
        ParsedSql parsedSql = statements.getSqlParser().parse(renderedSql, ctx);
        ctx.setParsedSql(parsedSql);
        return parsedSql;
    }

    <T> RowMapper<T> mapperForType(Class<T> type) {
        return this.mapperForType((Type)type);
    }

    <T> RowMapper<T> mapperForType(GenericType<T> type) {
        return this.mapperForType(type.getType());
    }

    RowMapper<?> mapperForType(Type type) {
        return this.getConfig(Mappers.class).findFor(type).orElseThrow(() -> new UnsupportedOperationException("No mapper registered for " + String.valueOf(type)));
    }

    void beforeTemplating() {
        this.callCustomizers(c -> c.beforeTemplating(this.stmt, this.getContext()));
    }

    void beforeBinding() {
        this.callCustomizers(c -> c.beforeBinding(this.stmt, this.getContext()));
    }

    void beforeExecution() {
        this.callCustomizers(c -> c.beforeExecution(this.stmt, this.getContext()));
    }

    void afterExecution() {
        this.callCustomizers(c -> c.afterExecution(this.stmt, this.getContext()));
    }

    private void attachJfrEvent(final OptionalEvent statementEvent, final StatementContext ctx) {
        if (statementEvent.shouldCommit()) {
            new Object(){

                void attach() {
                    JdbiStatementEvent evt = (JdbiStatementEvent)statementEvent;
                    evt.traceId = ctx.getTraceId();
                    evt.type = ctx.describeJdbiStatementType();
                    SqlStatements stmtConfig = SqlStatement.this.getConfig(SqlStatements.class);
                    String renderedSql = ctx.getRenderedSql();
                    if (renderedSql != null) {
                        evt.sql = renderedSql.substring(0, Math.min(renderedSql.length(), stmtConfig.getJfrSqlMaxLength()));
                    }
                    evt.parameters = SqlStatement.this.getBinding().describe(stmtConfig.getJfrParamMaxLength());
                    ctx.addCleanable(() -> {
                        evt.rowsMapped = ctx.getMappedRows();
                        evt.commit();
                    });
                }
            }.attach();
        }
    }
}

